/*
 * Decompiled with CFR 0.152.
 */
package com.choota.dev.ctimeago;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.choota.dev.ctimeago.R;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeAgo {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/M/yyyy HH:mm:ss");
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    DateFormat timeFormat = new SimpleDateFormat("h:mm aa");
    Date dateTimeNow;
    String timeFromData;
    String pastDate;
    String sDateTimeNow;
    @Nullable
    Context context;
    private static final int SECOND_MILLIS = 1000;
    private static final int MINUTE_MILLIS = 60000;
    private static final int HOUR_MILLIS = 3600000;
    private static final int DAY_MILLIS = 86400000;
    private static final int WEEKS_MILLIS = 604800000;
    private static final int MONTHS_MILLIS = -1875767296;

    public TimeAgo() {
        Date now = new Date();
        this.sDateTimeNow = this.simpleDateFormat.format(now);
        try {
            this.dateTimeNow = this.simpleDateFormat.parse(this.sDateTimeNow);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public TimeAgo locale(@NonNull Context context) {
        this.context = context;
        return this;
    }

    public TimeAgo with(@NonNull SimpleDateFormat simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
        this.dateFormat = new SimpleDateFormat(simpleDateFormat.toPattern().split(" ")[0]);
        this.timeFormat = new SimpleDateFormat(simpleDateFormat.toPattern().split(" ")[1]);
        return this;
    }

    public String getTimeAgo(Date startDate) {
        Date endDate = this.dateTimeNow;
        long different = endDate.getTime() - startDate.getTime();
        if (this.context == null) {
            if (different < 60000L) {
                return "just now";
            }
            if (different < 120000L) {
                return "a min ago";
            }
            if (different < 3000000L) {
                return different / 60000L + " mins ago";
            }
            if (different < 5400000L) {
                return "a hour ago";
            }
            if (different < 86400000L) {
                this.timeFromData = this.timeFormat.format(startDate);
                return this.timeFromData;
            }
            if (different < 172800000L) {
                return "yesterday";
            }
            if (different < 604800000L) {
                return different / 86400000L + " days ago";
            }
            if (different < 1209600000L) {
                return different / 604800000L + "week ago";
            }
            if ((double)different < 2.1168E9) {
                return different / 604800000L + " weeks ago";
            }
            this.pastDate = this.dateFormat.format(startDate);
            return this.pastDate;
        }
        if (different < 60000L) {
            return this.context.getResources().getString(R.string.just_now);
        }
        if (different < 120000L) {
            return this.context.getResources().getString(R.string.a_min_ago);
        }
        if (different < 3000000L) {
            return different / 60000L + this.context.getString(R.string.mins_ago);
        }
        if (different < 5400000L) {
            return this.context.getString(R.string.a_hour_ago);
        }
        if (different < 86400000L) {
            this.timeFromData = this.timeFormat.format(startDate);
            return this.timeFromData;
        }
        if (different < 172800000L) {
            return this.context.getString(R.string.yesterday);
        }
        if (different < 604800000L) {
            return different / 86400000L + this.context.getString(R.string.days_ago);
        }
        if (different < 1209600000L) {
            return different / 604800000L + this.context.getString(R.string.week_ago);
        }
        if ((double)different < 2.1168E9) {
            return different / 604800000L + this.context.getString(R.string.weeks_ago);
        }
        this.pastDate = this.dateFormat.format(startDate);
        return this.pastDate;
    }
}

