/*
 * Decompiled with CFR 0.152.
 */
package com.cloopen.rest.sdk;

import com.cloopen.rest.sdk.BodyType;
import com.cloopen.rest.sdk.utils.DateUtil;
import com.cloopen.rest.sdk.utils.HttpClientUtil;
import com.cloopen.rest.sdk.utils.ParmUtils;
import com.cloopen.rest.sdk.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CCPRestSmsSDK {
    private final Log log = LogFactory.getLog(CCPRestSmsSDK.class);
    private static final String TemplateSMS = "SMS/TemplateSMS";
    private static final String AcountType = "Accounts";
    private String SERVER_IP;
    private String SERVER_PORT;
    private String ACCOUNT_SID;
    private String ACCOUNT_TOKEN;
    private String App_ID;
    private BodyType BODY_TYPE = BodyType.Type_JSON;
    private Boolean USE_SSL = true;

    public void setBodyType(BodyType bodyType) {
        this.BODY_TYPE = bodyType;
    }

    public void init(String serverIP, String serverPort) {
        this.init(serverIP, serverPort, true);
    }

    public void init(String serverIP, String serverPort, Boolean useSSL) {
        if (StringUtils.isEmpty(serverIP) || StringUtils.isEmpty(serverPort)) {
            this.log.error((Object)"\u521d\u59cb\u5316\u5f02\u5e38:serverIP\u6216serverPort\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (StringUtils.isEmpty(serverIP) ? " \u670d\u52a1\u5668\u5730\u5740 " : "") + (StringUtils.isEmpty(serverPort) ? " \u670d\u52a1\u5668\u7aef\u53e3 " : "") + "\u4e3a\u7a7a");
        }
        this.SERVER_IP = serverIP;
        this.SERVER_PORT = serverPort;
        this.USE_SSL = useSSL;
    }

    public void setAccount(String accountSid, String accountToken) {
        if (StringUtils.isEmpty(accountSid) || StringUtils.isEmpty(accountToken)) {
            this.log.error((Object)"\u521d\u59cb\u5316\u5f02\u5e38:accountSid\u6216accountToken\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (StringUtils.isEmpty(accountSid) ? " \u4e3b\u5e10\u53f7\u540d\u79f0" : "") + (StringUtils.isEmpty(accountToken) ? " \u4e3b\u5e10\u53f7\u4ee4\u724c " : "") + "\u4e3a\u7a7a");
        }
        this.ACCOUNT_SID = accountSid;
        this.ACCOUNT_TOKEN = accountToken;
    }

    public void setAppId(String appId) {
        if (StringUtils.isEmpty(appId)) {
            this.log.error((Object)"\u521d\u59cb\u5316\u5f02\u5e38:appId\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5e94\u7528Id \u4e3a\u7a7a");
        }
        this.App_ID = appId;
    }

    public HashMap<String, Object> sendTemplateSMS(String to, String templateId, String[] datas) {
        return this.send(to, templateId, datas, null, null);
    }

    public HashMap<String, Object> sendTemplateSMS(String to, String templateId, String[] datas, String subAppend, String reqId) {
        return this.send(to, templateId, datas, subAppend, reqId);
    }

    private HashMap<String, Object> send(String to, String templateId, String[] datas, String subAppend, String reqId) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (StringUtils.isEmpty(to) || StringUtils.isEmpty(this.App_ID) || StringUtils.isEmpty(templateId)) {
            throw new IllegalArgumentException("\u5fc5\u586b\u53c2\u6570:" + (StringUtils.isEmpty(to) ? " \u624b\u673a\u53f7\u7801 " : "") + (StringUtils.isEmpty(templateId) ? " \u6a21\u677fId " : "") + "\u4e3a\u7a7a");
        }
        String timestamp = DateUtil.dateToStr(new Date(), 5);
        String sig = ParmUtils.generateSig(this.ACCOUNT_SID, this.ACCOUNT_TOKEN, timestamp);
        String authorization = "";
        try {
            authorization = ParmUtils.generateAuthorization(this.ACCOUNT_SID, timestamp);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("\u751f\u6210authorization\u5f02\u5e38" + e.getMessage());
        }
        String url = this.getBaseUrl().append("/Accounts/").append(this.ACCOUNT_SID).append("/SMS/TemplateSMS?sig=").append(sig).toString();
        String requsetbody = "";
        requsetbody = this.BODY_TYPE == BodyType.Type_JSON ? this.generateJson(to, templateId, datas, subAppend, reqId) : this.generateXml(to, templateId, datas, subAppend, reqId);
        this.log.info((Object)("sendTemplateSMS Request url:" + url));
        this.log.info((Object)("sendTemplateSMS Request body:" + requsetbody));
        String result = HttpClientUtil.post(url, authorization, requsetbody, this.BODY_TYPE, "utf-8");
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    private HashMap<String, Object> jsonToMap(String result) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JsonObject asJsonObject = JsonParser.parseString((String)result).getAsJsonObject();
        Set entrySet = asJsonObject.entrySet();
        HashMap hashMap2 = new HashMap();
        for (Map.Entry m : entrySet) {
            if ("statusCode".equals(m.getKey()) || "statusMsg".equals(m.getKey())) {
                hashMap.put((String)m.getKey(), ((JsonElement)m.getValue()).getAsString());
                continue;
            }
            if ("SubAccount".equals(m.getKey()) || "totalCount".equals(m.getKey()) || "token".equals(m.getKey()) || "downUrl".equals(m.getKey())) {
                if (!"SubAccount".equals(m.getKey())) {
                    hashMap2.put(m.getKey(), ((JsonElement)m.getValue()).getAsString());
                } else {
                    try {
                        if (((JsonElement)m.getValue()).toString().trim().length() <= 2 && !((JsonElement)m.getValue()).toString().contains("[")) {
                            hashMap2.put(m.getKey(), ((JsonElement)m.getValue()).getAsString());
                            hashMap.put("data", hashMap2);
                            break;
                        }
                        if (((JsonElement)m.getValue()).toString().contains("[]")) {
                            hashMap2.put(m.getKey(), new JsonArray());
                            hashMap.put("data", hashMap2);
                            continue;
                        }
                        JsonArray asJsonArray = JsonParser.parseString((String)((JsonElement)m.getValue()).toString()).getAsJsonArray();
                        ArrayList arrayList = new ArrayList();
                        for (JsonElement j : asJsonArray) {
                            Set entrySet2 = j.getAsJsonObject().entrySet();
                            HashMap hashMap3 = new HashMap();
                            Iterator iterator = entrySet2.iterator();
                            while (iterator.hasNext()) {
                                Map.Entry m2 = (Map.Entry)iterator.next();
                                hashMap3.put(m2.getKey(), ((JsonElement)m2.getValue()).getAsString());
                            }
                            arrayList.add(hashMap3);
                        }
                        hashMap2.put("SubAccount", arrayList);
                    }
                    catch (Exception e) {
                        JsonObject asJsonObject2 = JsonParser.parseString((String)((JsonElement)m.getValue()).toString()).getAsJsonObject();
                        Set entrySet2 = asJsonObject2.entrySet();
                        HashMap hashMap3 = new HashMap();
                        for (Map.Entry m2 : entrySet2) {
                            hashMap3.put(m2.getKey(), ((JsonElement)m2.getValue()).getAsString());
                        }
                        hashMap2.put(m.getKey(), hashMap3);
                        hashMap.put("data", hashMap2);
                    }
                }
                hashMap.put("data", hashMap2);
                continue;
            }
            JsonObject asJsonObject2 = JsonParser.parseString((String)((JsonElement)m.getValue()).toString()).getAsJsonObject();
            Set entrySet2 = asJsonObject2.entrySet();
            HashMap hashMap3 = new HashMap();
            for (Map.Entry m2 : entrySet2) {
                hashMap3.put(m2.getKey(), ((JsonElement)m2.getValue()).getAsString());
            }
            if (hashMap3.size() != 0) {
                hashMap2.put(m.getKey(), hashMap3);
            } else {
                hashMap2.put(m.getKey(), ((JsonElement)m.getValue()).getAsString());
            }
            hashMap.put("data", hashMap2);
        }
        return hashMap;
    }

    private HashMap<String, Object> xmlToMap(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
            Element rootElt = doc.getRootElement();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Iterator i = rootElt.elementIterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                if ("statusCode".equals(e.getName()) || "statusMsg".equals(e.getName())) {
                    map.put(e.getName(), e.getText());
                    continue;
                }
                if ("SubAccount".equals(e.getName()) || "totalCount".equals(e.getName()) || "token".equals(e.getName()) || "downUrl".equals(e.getName())) {
                    if (!"SubAccount".equals(e.getName())) {
                        hashMap2.put(e.getName(), e.getText());
                    } else {
                        ArrayList arrayList = new ArrayList();
                        HashMap<String, String> hashMap3 = new HashMap<String, String>();
                        Iterator i2 = e.elementIterator();
                        while (i2.hasNext()) {
                            Element e2 = (Element)i2.next();
                            hashMap3.put(e2.getName(), e2.getText());
                            arrayList.add(hashMap3);
                        }
                        hashMap2.put("SubAccount", arrayList);
                    }
                    map.put("data", hashMap2);
                    continue;
                }
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                Iterator i2 = e.elementIterator();
                while (i2.hasNext()) {
                    Element e2 = (Element)i2.next();
                    hashMap3.put(e2.getName(), e2.getText());
                }
                if (hashMap3.size() != 0) {
                    hashMap2.put(e.getName(), hashMap3);
                } else {
                    hashMap2.put(e.getName(), e.getText());
                }
                map.put("data", hashMap2);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.log.error((Object)e.getMessage());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    private String generateJson(String to, String templateId, String[] datas, String subAppend, String reqId) {
        JsonObject json = new JsonObject();
        json.addProperty("appId", this.App_ID);
        json.addProperty("to", to);
        json.addProperty("templateId", templateId);
        if (datas != null) {
            StringBuilder sb = new StringBuilder("[");
            for (String s : datas) {
                sb.append("\"");
                sb.append(s);
                sb.append("\"");
                sb.append(",");
            }
            sb.replace(sb.length() - 1, sb.length(), "]");
            JsonArray jarray = JsonParser.parseString((String)sb.toString()).getAsJsonArray();
            json.add("datas", (JsonElement)jarray);
        }
        if (!StringUtils.isBlank(subAppend) && ParmUtils.checkSubAppend(subAppend)) {
            json.addProperty("subAppend", subAppend);
        }
        if (!StringUtils.isBlank(reqId) && ParmUtils.checkReqId(reqId)) {
            json.addProperty("reqId", reqId);
        }
        return json.toString();
    }

    private String generateXml(String to, String templateId, String[] datas, String subAppend, String reqId) {
        StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><TemplateSMS>");
        sb.append("<appId>").append(this.App_ID).append("</appId>").append("<to>").append(to).append("</to>").append("<templateId>").append(templateId).append("</templateId>");
        if (datas != null) {
            sb.append("<datas>");
            for (String s : datas) {
                sb.append("<data>").append(s).append("</data>");
            }
            sb.append("</datas>");
        }
        if (!StringUtils.isBlank(subAppend) && ParmUtils.checkSubAppend(subAppend)) {
            sb.append("<subAppend>").append(subAppend).append("</subAppend>");
        }
        if (!StringUtils.isBlank(reqId) && ParmUtils.checkReqId(reqId)) {
            sb.append("<reqId>").append(reqId).append("</reqId>");
        }
        sb.append("</TemplateSMS>").toString();
        return sb.toString();
    }

    private StringBuffer getBaseUrl() {
        StringBuffer sb = new StringBuffer();
        if (this.USE_SSL.booleanValue()) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(this.SERVER_IP).append(":").append(this.SERVER_PORT);
        sb.append("/2013-12-26");
        return sb;
    }

    private HashMap<String, Object> getMyError(String code, String msg) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("statusCode", code);
        hashMap.put("statusMsg", msg);
        return hashMap;
    }

    private HashMap<String, Object> accountValidate() {
        if (StringUtils.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (StringUtils.isEmpty(this.ACCOUNT_SID)) {
            return this.getMyError("172006", "\u4e3b\u5e10\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(this.ACCOUNT_TOKEN)) {
            return this.getMyError("172007", "\u4e3b\u5e10\u53f7\u4ee4\u724c\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(this.App_ID)) {
            return this.getMyError("172012", "\u5e94\u7528ID\u4e3a\u7a7a");
        }
        return null;
    }
}

