/*
 * Decompiled with CFR 0.152.
 */
package com.cloopen.rest.sdk.utils;

import com.cloopen.rest.sdk.BodyType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final Log log = LogFactory.getLog(HttpClientUtil.class);
    public static final int CONNECTION_TIMEOUT = 5000;
    public static final int CONNECTION_REQUEST_TIMEOUT = 5000;
    public static final int SOCKET_TIMEOUT = 10000;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String post(String url, Map<String, String> reqMap) {
        return HttpClientUtil.post(url, reqMap, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> reqMap, String encoding) {
        String result = "";
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (reqMap != null && reqMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entity : reqMap.entrySet()) {
                params.add(new BasicNameValuePair(entity.getKey(), entity.getValue()));
            }
        }
        CloseableHttpClient httpClient = null;
        httpClient = url.startsWith(HTTPS) ? HttpClientUtil.createSSLInsecureClient() : HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(10000).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, encoding));
            response = httpClient.execute((HttpUriRequest)httpPost);
            result = HttpClientUtil.handleResponse(url, encoding, response);
            HttpClientUtil.closeResource(httpClient, response);
        }
        catch (IOException e) {
            log.error((Object)("-----> url:" + url + ",post\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            HttpClientUtil.closeResource(httpClient, response);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String authorization, String strParams, BodyType BODY_TYPE, String encoding) {
        String result = "";
        CloseableHttpClient httpClient = null;
        httpClient = url.startsWith(HTTPS) ? HttpClientUtil.createSSLInsecureClient() : HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(10000).setRedirectsEnabled(true).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Authorization", authorization);
            if (BODY_TYPE == BodyType.Type_JSON) {
                httpPost.setHeader("Accept", "application/json");
                httpPost.setHeader("Content-Type", "application/json;charset=" + encoding);
                httpPost.setEntity((HttpEntity)new StringEntity(strParams, ContentType.create((String)"application/json", (String)encoding)));
            } else {
                httpPost.setHeader("Accept", "application/xml");
                httpPost.setHeader("Content-Type", "application/xml;charset=" + encoding);
                httpPost.setEntity((HttpEntity)new StringEntity(strParams, ContentType.create((String)"application/xml", (String)encoding)));
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            result = HttpClientUtil.handleResponse(url, encoding, response);
            log.info((Object)("Response body:" + result));
            HttpClientUtil.closeResource(httpClient, response);
        }
        catch (IOException e) {
            log.error((Object)("-----> url:" + url + ",post\u8bf7\u6c42\u5f02\u5e38:" + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            HttpClientUtil.closeResource(httpClient, response);
        }
        return result;
    }

    public static CloseableHttpClient createSSLInsecureClient() {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslcsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslcsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String handleResponse(String url, String encoding, CloseableHttpResponse response) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        br = new BufferedReader(new InputStreamReader(entity.getContent(), encoding));
                        String s = null;
                        while ((s = br.readLine()) != null) {
                            sb.append(s);
                        }
                    }
                    EntityUtils.consume((HttpEntity)entity);
                } else if (response.getStatusLine().getStatusCode() == 404) {
                    log.info((Object)("-----> get\u8bf7\u6c42404,\u672a\u627e\u5230\u8d44\u6e90. url:" + url));
                } else if (response.getStatusLine().getStatusCode() == 500) {
                    log.info((Object)("-----> get\u8bf7\u6c42500,\u670d\u52a1\u5668\u7aef\u5f02\u5e38. url:" + url));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("----->url:" + url + ",\u5904\u7406\u54cd\u5e94\uff0c\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u5f02\u5e38\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    private static void closeResource(CloseableHttpClient httpClient, CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                log.error((Object)("-----> \u91ca\u653eresponse\u8d44\u6e90\u5f02\u5e38:" + e.getMessage()));
                e.printStackTrace();
            }
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                log.error((Object)("-----> \u91ca\u653ehttpclient\u8d44\u6e90\u5f02\u5e38:" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSLv3");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }
}

