/*
 * Decompiled with CFR 0.152.
 */
package com.cloopen.rest.sdk.utils;

import com.cloopen.rest.sdk.utils.Encrypt;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class ParmUtils {
    public static String generateSig(String accountSid, String accountToken, String timestamp) {
        StringBuffer sb = new StringBuffer(accountSid).append(accountToken).append(timestamp);
        String sig = Encrypt.encryptMD5(sb.toString()).toUpperCase();
        return sig;
    }

    public static String generateAuthorization(String accountSid, String timestamp) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer(accountSid).append(":").append(timestamp);
        String authorization = new String(Base64.encodeBase64((byte[])sb.toString().getBytes("utf-8")), "utf-8");
        return authorization;
    }

    public static boolean checkSubAppend(String subAppend) {
        if (subAppend.length() > 4) {
            return false;
        }
        return ParmUtils.isInteger(subAppend);
    }

    public static boolean checkReqId(String reqId) {
        if (reqId.length() > 32) {
            return false;
        }
        return ParmUtils.isLetterDigit(reqId);
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isLetterDigit(String str) {
        String regex = "^[a-z0-9A-Z]+$";
        return str.matches(regex);
    }
}

