/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.aspect;

import com.codingapi.txlcn.client.aspect.weave.DTXResourceWeaver;
import com.codingapi.txlcn.client.config.TxClientConfig;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class DataSourceAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(DataSourceAspect.class);
    private final TxClientConfig txClientConfig;
    private final DTXResourceWeaver dtxResourceWeaver;

    public DataSourceAspect(TxClientConfig txClientConfig, DTXResourceWeaver dtxResourceWeaver) {
        this.txClientConfig = txClientConfig;
        this.dtxResourceWeaver = dtxResourceWeaver;
    }

    @Around(value="execution(* javax.sql.DataSource.getConnection(..))")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        return this.dtxResourceWeaver.around(point);
    }

    public int getOrder() {
        return this.txClientConfig.getResourceOrder();
    }
}

