/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.aspect;

import com.codingapi.txlcn.client.aspect.weave.DTXLogicWeaver;
import com.codingapi.txlcn.client.bean.DTXInfo;
import com.codingapi.txlcn.client.config.TxClientConfig;
import com.codingapi.txlcn.client.support.DTXInfoPool;
import com.codingapi.txlcn.commons.annotation.DTXPropagation;
import com.codingapi.txlcn.commons.annotation.ITxTransaction;
import com.codingapi.txlcn.commons.annotation.LcnTransaction;
import com.codingapi.txlcn.commons.annotation.TccTransaction;
import com.codingapi.txlcn.commons.annotation.TxTransaction;
import com.codingapi.txlcn.commons.annotation.TxcTransaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class TransactionAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(TransactionAspect.class);
    private final TxClientConfig txClientConfig;
    private final DTXLogicWeaver dtxLogicWeaver;

    public TransactionAspect(TxClientConfig txClientConfig, DTXLogicWeaver dtxLogicWeaver) {
        this.txClientConfig = txClientConfig;
        this.dtxLogicWeaver = dtxLogicWeaver;
    }

    @Pointcut(value="@annotation(com.codingapi.txlcn.commons.annotation.TxTransaction)")
    public void txTransactionPointcut() {
    }

    @Pointcut(value="@annotation(com.codingapi.txlcn.commons.annotation.LcnTransaction)")
    public void lcnTransactionPointcut() {
    }

    @Pointcut(value="@annotation(com.codingapi.txlcn.commons.annotation.TxcTransaction)")
    public void txcTransactionPointcut() {
    }

    @Pointcut(value="@annotation(com.codingapi.txlcn.commons.annotation.TccTransaction)")
    public void tccTransactionPointcut() {
    }

    @Around(value="txTransactionPointcut()")
    public Object transactionRunning(ProceedingJoinPoint point) throws Throwable {
        DTXInfo dtxInfo = DTXInfoPool.get(point);
        TxTransaction txTransaction = dtxInfo.getBusinessMethod().getAnnotation(TxTransaction.class);
        dtxInfo.setTransactionType(txTransaction.type());
        dtxInfo.setTransactionPropagation(txTransaction.propagation());
        return this.dtxLogicWeaver.runTransaction(dtxInfo, () -> ((ProceedingJoinPoint)point).proceed());
    }

    @Around(value="lcnTransactionPointcut() && !txcTransactionPointcut()&& !tccTransactionPointcut() && !txTransactionPointcut()")
    public Object runWithLcnTransaction(ProceedingJoinPoint point) throws Throwable {
        DTXInfo dtxInfo = DTXInfoPool.get(point);
        LcnTransaction lcnTransaction = dtxInfo.getBusinessMethod().getAnnotation(LcnTransaction.class);
        dtxInfo.setTransactionType("lcn");
        dtxInfo.setTransactionPropagation(lcnTransaction.propagation());
        return this.dtxLogicWeaver.runTransaction(dtxInfo, () -> ((ProceedingJoinPoint)point).proceed());
    }

    @Around(value="txcTransactionPointcut() && !lcnTransactionPointcut()&& !tccTransactionPointcut() && !txTransactionPointcut()")
    public Object runWithTxcTransaction(ProceedingJoinPoint point) throws Throwable {
        DTXInfo dtxInfo = DTXInfoPool.get(point);
        TxcTransaction txcTransaction = dtxInfo.getBusinessMethod().getAnnotation(TxcTransaction.class);
        dtxInfo.setTransactionType("txc");
        dtxInfo.setTransactionPropagation(txcTransaction.propagation());
        return this.dtxLogicWeaver.runTransaction(dtxInfo, () -> ((ProceedingJoinPoint)point).proceed());
    }

    @Around(value="tccTransactionPointcut() && !lcnTransactionPointcut()&& !txcTransactionPointcut() && !txTransactionPointcut()")
    public Object runWithTccTransaction(ProceedingJoinPoint point) throws Throwable {
        DTXInfo dtxInfo = DTXInfoPool.get(point);
        TccTransaction tccTransaction = dtxInfo.getBusinessMethod().getAnnotation(TccTransaction.class);
        dtxInfo.setTransactionType("tcc");
        dtxInfo.setTransactionPropagation(tccTransaction.propagation());
        return this.dtxLogicWeaver.runTransaction(dtxInfo, () -> ((ProceedingJoinPoint)point).proceed());
    }

    @Around(value="this(com.codingapi.txlcn.commons.annotation.ITxTransaction) && execution( * *(..))")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        if (!(point.getThis() instanceof ITxTransaction)) {
            throw new IllegalStateException("error join point");
        }
        DTXInfo dtxInfo = DTXInfoPool.get(point);
        ITxTransaction txTransaction = (ITxTransaction)point.getThis();
        dtxInfo.setTransactionType(txTransaction.transactionType());
        dtxInfo.setTransactionPropagation(DTXPropagation.REQUIRED);
        return this.dtxLogicWeaver.runTransaction(dtxInfo, () -> ((ProceedingJoinPoint)point).proceed());
    }

    public int getOrder() {
        return this.txClientConfig.getDtxAspectOrder();
    }
}

