/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.aspect.interceptor;

import com.codingapi.txlcn.client.bean.DTXInfo;
import com.codingapi.txlcn.client.support.DTXInfoPool;
import com.codingapi.txlcn.commons.annotation.DTXPropagation;
import com.codingapi.txlcn.commons.annotation.LcnTransaction;
import com.codingapi.txlcn.commons.annotation.TccTransaction;
import com.codingapi.txlcn.commons.annotation.TxTransaction;
import com.codingapi.txlcn.commons.annotation.TxcTransaction;
import java.util.Objects;
import org.aopalliance.intercept.MethodInvocation;

class InterceptorInvocationUtils {
    InterceptorInvocationUtils() {
    }

    static DTXInfo load(MethodInvocation invocation) {
        TxTransaction txTransaction = invocation.getMethod().getAnnotation(TxTransaction.class);
        String transactionType = "lcn";
        DTXPropagation dtxPropagation = DTXPropagation.REQUIRED;
        if (Objects.nonNull(txTransaction)) {
            transactionType = txTransaction.type();
            dtxPropagation = txTransaction.propagation();
        } else {
            LcnTransaction lcnTransaction = invocation.getMethod().getAnnotation(LcnTransaction.class);
            if (Objects.nonNull(lcnTransaction)) {
                transactionType = "lcn";
                dtxPropagation = lcnTransaction.propagation();
            } else {
                TxcTransaction txcTransaction = invocation.getMethod().getAnnotation(TxcTransaction.class);
                if (Objects.nonNull(txcTransaction)) {
                    transactionType = "txc";
                    dtxPropagation = txcTransaction.propagation();
                } else {
                    TccTransaction tccTransaction = invocation.getMethod().getAnnotation(TccTransaction.class);
                    if (Objects.nonNull(tccTransaction)) {
                        transactionType = "tcc";
                        dtxPropagation = tccTransaction.propagation();
                    }
                }
            }
        }
        DTXInfo dtxInfo = DTXInfoPool.get(invocation);
        dtxInfo.setTransactionType(transactionType);
        dtxInfo.setTransactionPropagation(dtxPropagation);
        return dtxInfo;
    }
}

