/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.aspect.weave;

import com.codingapi.txlcn.client.aspect.BusinessCallback;
import com.codingapi.txlcn.client.bean.DTXInfo;
import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.support.TXLCNTransactionServiceExecutor;
import com.codingapi.txlcn.client.support.cache.DTXGroupContext;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.commons.util.RandomUtils;
import com.codingapi.txlcn.spi.sleuth.TracerHelper;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTXLogicWeaver {
    private static final Logger log = LoggerFactory.getLogger(DTXLogicWeaver.class);
    private final TracerHelper tracerHelper;
    private final TXLCNTransactionServiceExecutor transactionServiceExecutor;
    private final TransactionAttachmentCache transactionAttachmentCache;

    public DTXLogicWeaver(TracerHelper tracerHelper, TXLCNTransactionServiceExecutor transactionServiceExecutor, TransactionAttachmentCache transactionAttachmentCache) {
        this.tracerHelper = tracerHelper;
        this.transactionServiceExecutor = transactionServiceExecutor;
        this.transactionAttachmentCache = transactionAttachmentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runTransaction(DTXInfo dtxInfo, BusinessCallback business) throws Throwable {
        if (!Objects.isNull(DTXLocal.cur())) {
            return business.call();
        }
        DTXLocal.getOrNew();
        log.debug("tx-unit start---->");
        boolean isTransactionStart = this.tracerHelper.getGroupId() == null;
        String groupId = isTransactionStart ? RandomUtils.randomKey() : this.tracerHelper.getGroupId();
        String unitId = dtxInfo.getUnitId();
        DTXLocal dtxLocal = DTXLocal.getOrNew();
        if (dtxLocal.getUnitId() != null) {
            dtxLocal.setInUnit(true);
            log.info("tx > unit[{}] in unit: {}", (Object)unitId, (Object)dtxLocal.getUnitId());
        }
        dtxLocal.setUnitId(unitId);
        dtxLocal.setGroupId(groupId);
        dtxLocal.setTransactionType(dtxInfo.getTransactionType());
        TxTransactionInfo info = new TxTransactionInfo(dtxInfo.getTransactionType(), isTransactionStart, groupId, unitId, dtxInfo.getTransactionInfo(), business, dtxInfo.getBusinessMethod(), dtxInfo.getTransactionPropagation());
        try {
            this.transactionAttachmentCache.setContext(info.getGroupId(), new DTXGroupContext());
            Object object = this.transactionServiceExecutor.transactionRunning(info);
            return object;
        }
        finally {
            DTXGroupContext context = (DTXGroupContext)this.transactionAttachmentCache.context(info.getGroupId());
            Object object = context.getLock();
            synchronized (object) {
                context.getLock().notifyAll();
            }
            this.transactionAttachmentCache.destroyContext(info.getGroupId());
            DTXLocal.makeNeverAppeared();
            log.debug("tx-unit end------>");
        }
    }
}

