/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.aspect.weave;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.support.TXLCNTransactionBeanHelper;
import com.codingapi.txlcn.client.support.resouce.TransactionResourceExecutor;
import java.sql.Connection;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTXResourceWeaver {
    private static final Logger log = LoggerFactory.getLogger(DTXResourceWeaver.class);
    private final TXLCNTransactionBeanHelper transactionBeanHelper;

    public DTXResourceWeaver(TXLCNTransactionBeanHelper transactionBeanHelper) {
        this.transactionBeanHelper = transactionBeanHelper;
    }

    public Object around(ProceedingJoinPoint point) throws Throwable {
        DTXLocal dtxLocal = DTXLocal.cur();
        if (Objects.nonNull(dtxLocal) && dtxLocal.isProxy()) {
            String transactionType = dtxLocal.getTransactionType();
            TransactionResourceExecutor transactionResourceExecutor = this.transactionBeanHelper.loadTransactionResourceExecuter(transactionType);
            Connection connection = transactionResourceExecutor.proxyConnection(() -> {
                try {
                    return (Connection)point.proceed();
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException(throwable);
                }
            });
            log.debug("proxy a sql connection: {}.", (Object)connection);
            return connection;
        }
        return point.proceed();
    }
}

