/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.aspectlog;

import com.codingapi.txlcn.client.aspectlog.AspectLogDbProperties;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.h2.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;

public class AspectLogDbHelper
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AspectLogDbHelper.class);
    private HikariDataSource hikariDataSource;
    private QueryRunner queryRunner;

    @Autowired
    public AspectLogDbHelper(AspectLogDbProperties aspectLogDbProperties) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(Driver.class.getName());
        log.info("init db at {}", (Object)aspectLogDbProperties.getFilePath());
        hikariConfig.setJdbcUrl(String.format("jdbc:h2:%s", aspectLogDbProperties.getFilePath()));
        this.hikariDataSource = new HikariDataSource(hikariConfig);
        this.queryRunner = new QueryRunner((DataSource)this.hikariDataSource);
        log.info("init db finish.");
    }

    public int update(String sql, Object ... params) {
        try {
            return this.queryRunner.update(sql, params);
        }
        catch (SQLException e) {
            log.error("update error", (Throwable)e);
            return 0;
        }
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object ... params) {
        try {
            return (T)this.queryRunner.query(sql, rsh, params);
        }
        catch (SQLException e) {
            log.error("query error", (Throwable)e);
            return null;
        }
    }

    public <T> T query(String sql, ScalarHandler<T> scalarHandler, Object ... params) {
        try {
            return (T)this.queryRunner.query(sql, scalarHandler, params);
        }
        catch (SQLException e) {
            log.error("query error", (Throwable)e);
            return null;
        }
    }

    public void destroy() throws Exception {
        this.hikariDataSource.close();
        log.info("log hikariDataSource close.");
    }
}

