/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.aspectlog;

import java.io.File;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(value="tx-lcn.aspect.log")
public class AspectLogDbProperties {
    private String filePath;

    public AspectLogDbProperties(ConfigurableEnvironment environment, ServerProperties serverProperties) {
        String applicationName = environment.getProperty("spring.application.name");
        this.filePath = System.getProperty("user.dir") + File.separator + ".txlcn" + File.separator + (StringUtils.hasText((String)applicationName) ? applicationName : "application") + "-" + serverProperties.getPort();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectLogDbProperties)) {
            return false;
        }
        AspectLogDbProperties other = (AspectLogDbProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AspectLogDbProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        return result;
    }

    public String toString() {
        return "AspectLogDbProperties(filePath=" + this.getFilePath() + ")";
    }
}

