/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.bean;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTXLocal {
    private static final Logger log = LoggerFactory.getLogger(DTXLocal.class);
    private static final ThreadLocal<DTXLocal> currentLocal = new InheritableThreadLocal<DTXLocal>();
    private String transactionType;
    private String groupId;
    private String unitId;
    private Object resource;
    private boolean inUnit;
    private Object attachment;
    private int sysTransactionState = 1;
    private int userTransactionState = -1;
    private boolean proxy;
    private boolean justNow;
    private boolean proxyTmp;

    private boolean isProxyTmp() {
        return this.proxyTmp;
    }

    private void setProxyTmp(boolean proxyTmp) {
        this.proxyTmp = proxyTmp;
    }

    public static DTXLocal cur() {
        return currentLocal.get();
    }

    public static DTXLocal getOrNew() {
        if (currentLocal.get() == null) {
            currentLocal.set(new DTXLocal());
        }
        return currentLocal.get();
    }

    public static void makeProxy() {
        if (currentLocal.get() != null) {
            DTXLocal.cur().proxyTmp = DTXLocal.cur().proxy;
            DTXLocal.cur().proxy = true;
        }
    }

    public static void makeUnProxy() {
        if (currentLocal.get() != null) {
            DTXLocal.cur().proxyTmp = DTXLocal.cur().proxy;
            DTXLocal.cur().proxy = false;
        }
    }

    public static void undoProxyStatus() {
        if (currentLocal.get() != null) {
            DTXLocal.cur().proxy = DTXLocal.cur().proxyTmp;
        }
    }

    public static void makeNeverAppeared() {
        if (currentLocal.get() != null) {
            log.debug("clean thread local[{}]: {}", (Object)DTXLocal.class.getSimpleName(), (Object)DTXLocal.cur());
            currentLocal.set(null);
        }
    }

    public static int transactionState() {
        DTXLocal dtxLocal = Objects.requireNonNull(currentLocal.get(), "DTX can't be null.");
        return dtxLocal.userTransactionState == -1 ? dtxLocal.sysTransactionState : dtxLocal.userTransactionState;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public Object getResource() {
        return this.resource;
    }

    public boolean isInUnit() {
        return this.inUnit;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public int getSysTransactionState() {
        return this.sysTransactionState;
    }

    public int getUserTransactionState() {
        return this.userTransactionState;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isJustNow() {
        return this.justNow;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public void setResource(Object resource) {
        this.resource = resource;
    }

    public void setInUnit(boolean inUnit) {
        this.inUnit = inUnit;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public void setSysTransactionState(int sysTransactionState) {
        this.sysTransactionState = sysTransactionState;
    }

    public void setUserTransactionState(int userTransactionState) {
        this.userTransactionState = userTransactionState;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public void setJustNow(boolean justNow) {
        this.justNow = justNow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DTXLocal)) {
            return false;
        }
        DTXLocal other = (DTXLocal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$transactionType = this.getTransactionType();
        String other$transactionType = other.getTransactionType();
        if (this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$unitId = this.getUnitId();
        String other$unitId = other.getUnitId();
        if (this$unitId == null ? other$unitId != null : !this$unitId.equals(other$unitId)) {
            return false;
        }
        Object this$resource = this.getResource();
        Object other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        if (this.isInUnit() != other.isInUnit()) {
            return false;
        }
        Object this$attachment = this.getAttachment();
        Object other$attachment = other.getAttachment();
        if (this$attachment == null ? other$attachment != null : !this$attachment.equals(other$attachment)) {
            return false;
        }
        if (this.getSysTransactionState() != other.getSysTransactionState()) {
            return false;
        }
        if (this.getUserTransactionState() != other.getUserTransactionState()) {
            return false;
        }
        if (this.isProxy() != other.isProxy()) {
            return false;
        }
        if (this.isJustNow() != other.isJustNow()) {
            return false;
        }
        return this.isProxyTmp() == other.isProxyTmp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DTXLocal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transactionType = this.getTransactionType();
        result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $unitId = this.getUnitId();
        result = result * 59 + ($unitId == null ? 43 : $unitId.hashCode());
        Object $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        result = result * 59 + (this.isInUnit() ? 79 : 97);
        Object $attachment = this.getAttachment();
        result = result * 59 + ($attachment == null ? 43 : $attachment.hashCode());
        result = result * 59 + this.getSysTransactionState();
        result = result * 59 + this.getUserTransactionState();
        result = result * 59 + (this.isProxy() ? 79 : 97);
        result = result * 59 + (this.isJustNow() ? 79 : 97);
        result = result * 59 + (this.isProxyTmp() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DTXLocal(transactionType=" + this.getTransactionType() + ", groupId=" + this.getGroupId() + ", unitId=" + this.getUnitId() + ", resource=" + this.getResource() + ", inUnit=" + this.isInUnit() + ", attachment=" + this.getAttachment() + ", sysTransactionState=" + this.getSysTransactionState() + ", userTransactionState=" + this.getUserTransactionState() + ", proxy=" + this.isProxy() + ", justNow=" + this.isJustNow() + ", proxyTmp=" + this.isProxyTmp() + ")";
    }
}

