/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.lcn.control;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.support.TXLCNTransactionControl;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.client.support.template.TransactionControlTemplate;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.commons.exception.TxClientException;
import com.codingapi.txlcn.spi.sleuth.TracerHelper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="control_lcn_running")
public class LcnRunningTransaction
implements TXLCNTransactionControl {
    private static final Logger log = LoggerFactory.getLogger(LcnRunningTransaction.class);
    private final TracerHelper tracerHelper;
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TransactionControlTemplate transactionControlTemplate;

    @Autowired
    public LcnRunningTransaction(TracerHelper tracerHelper, TransactionCleanTemplate transactionCleanTemplate, TransactionControlTemplate transactionControlTemplate) {
        this.tracerHelper = tracerHelper;
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.transactionControlTemplate = transactionControlTemplate;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) {
        DTXLocal.makeProxy();
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        try {
            this.transactionCleanTemplate.clean(info.getGroupId(), info.getUnitId(), info.getTransactionType(), 0);
        }
        catch (TransactionClearException e) {
            log.error("{} > clean transaction error.", (Object)"lcn");
        }
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) throws TxClientException {
        log.debug("join group: [GroupId: {}, TxManager:{}, Method: {}]", new Object[]{info.getGroupId(), Optional.ofNullable(this.tracerHelper.getTxManagerKey()).orElseThrow(() -> new RuntimeException("sleuth pass error.")), info.getTransactionInfo().getMethodStr()});
        this.transactionControlTemplate.joinGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), info.getTransactionInfo());
    }
}

