/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.lcn.control;

import com.codingapi.txlcn.client.core.lcn.resource.LcnConnectionProxy;
import com.codingapi.txlcn.client.support.TransactionCleanService;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.spi.message.dto.RpcResponseState;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LcnTransactionCleanService
implements TransactionCleanService {
    private static final Logger log = LoggerFactory.getLogger(LcnTransactionCleanService.class);
    private final TransactionAttachmentCache transactionAttachmentCache;

    @Autowired
    public LcnTransactionCleanService(TransactionAttachmentCache transactionAttachmentCache) {
        this.transactionAttachmentCache = transactionAttachmentCache;
    }

    @Override
    public void clear(String groupId, int state, String unitId, String unitType) throws TransactionClearException {
        Optional<LcnConnectionProxy> lcnConnectionProxy = this.transactionAttachmentCache.attachment(groupId, LcnConnectionProxy.class);
        if (lcnConnectionProxy.isPresent()) {
            if (lcnConnectionProxy.get().notify(state).equals((Object)RpcResponseState.success)) {
                this.transactionAttachmentCache.removeAttachments(groupId, unitId);
                return;
            }
            log.error("\u672c\u5730\u4e8b\u52a1\u901a\u77e5\u5931\u8d25");
            throw new TransactionClearException("\u901a\u77e5\u8d44\u6e90\u65f6\u51fa\u9519");
        }
        log.error("local non transaction, but notified. probably net message timeout . groupId: {}, transactionState: {}", (Object)groupId, (Object)state);
        throw new TransactionClearException("local non transaction, but notified. probably net message timeout .");
    }
}

