/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.lcn.resource;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.core.lcn.resource.LcnConnectionProxy;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.client.support.resouce.TransactionResourceExecutor;
import java.sql.Connection;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="transaction_lcn")
public class LcnTransactionResourceExecutor
implements TransactionResourceExecutor {
    private static final Logger log = LoggerFactory.getLogger(LcnTransactionResourceExecutor.class);
    private final TransactionAttachmentCache transactionAttachmentCache;

    @Autowired
    public LcnTransactionResourceExecutor(TransactionAttachmentCache transactionAttachmentCache) {
        this.transactionAttachmentCache = transactionAttachmentCache;
    }

    @Override
    public Connection proxyConnection(Supplier<Connection> connectionSupplier) throws Throwable {
        String groupId = DTXLocal.cur().getGroupId();
        String unitId = DTXLocal.cur().getUnitId();
        Connection connection = this.transactionAttachmentCache.attachment(groupId, unitId, LcnConnectionProxy.class, () -> new LcnConnectionProxy((Connection)connectionSupplier.get()));
        connection.setAutoCommit(false);
        return connection;
    }
}

