/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.tcc.control;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TCCTransactionInfo;
import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.core.tcc.TccTransactionInfoCache;
import com.codingapi.txlcn.client.core.tcc.control.TccStartingTransaction;
import com.codingapi.txlcn.client.support.TXLCNTransactionControl;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.client.support.template.TransactionControlTemplate;
import com.codingapi.txlcn.commons.exception.BeforeBusinessException;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.commons.exception.TxClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="control_tcc_running")
public class TccRunningTransaction
implements TXLCNTransactionControl {
    private static final Logger log = LoggerFactory.getLogger(TccRunningTransaction.class);
    private final TccTransactionInfoCache tccTransactionInfoCache;
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TransactionControlTemplate transactionControlTemplate;

    @Autowired
    public TccRunningTransaction(TransactionCleanTemplate transactionCleanTemplate, TransactionControlTemplate transactionControlTemplate, TccTransactionInfoCache tccTransactionInfoCache) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.transactionControlTemplate = transactionControlTemplate;
        this.tccTransactionInfoCache = tccTransactionInfoCache;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) throws BeforeBusinessException {
        if (this.tccTransactionInfoCache.get(info.getUnitId()) == null) {
            this.tccTransactionInfoCache.putIfAbsent(info.getUnitId(), TccStartingTransaction.prepareTccInfo(info));
        }
        ((TCCTransactionInfo)this.tccTransactionInfoCache.get(info.getUnitId())).setMethodParameter(info.getTransactionInfo().getArgumentValues());
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        try {
            this.transactionCleanTemplate.clean(DTXLocal.cur().getGroupId(), info.getUnitId(), info.getTransactionType(), 0);
        }
        catch (TransactionClearException e) {
            log.error("tcc > clean transaction error.", (Throwable)e);
        }
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) throws TxClientException {
        this.transactionControlTemplate.joinGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), info.getTransactionInfo());
    }
}

