/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.tcc.control;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TCCTransactionInfo;
import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.core.tcc.TccTransactionInfoCache;
import com.codingapi.txlcn.client.support.TXLCNTransactionControl;
import com.codingapi.txlcn.client.support.template.TransactionControlTemplate;
import com.codingapi.txlcn.commons.annotation.TccTransaction;
import com.codingapi.txlcn.commons.exception.BeforeBusinessException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="control_tcc_starting")
public class TccStartingTransaction
implements TXLCNTransactionControl {
    private static final Logger log = LoggerFactory.getLogger(TccStartingTransaction.class);
    private final TransactionControlTemplate transactionControlTemplate;
    private final TccTransactionInfoCache tccTransactionInfoCache;

    @Autowired
    public TccStartingTransaction(TransactionControlTemplate transactionControlTemplate, TccTransactionInfoCache tccTransactionInfoCache) {
        this.transactionControlTemplate = transactionControlTemplate;
        this.tccTransactionInfoCache = tccTransactionInfoCache;
    }

    static TCCTransactionInfo prepareTccInfo(TxTransactionInfo info) throws BeforeBusinessException {
        Method method = info.getPointMethod();
        TccTransaction tccTransaction = method.getAnnotation(TccTransaction.class);
        if (tccTransaction == null) {
            throw new BeforeBusinessException("TCC type need @TccTransaction in " + method.getName());
        }
        String cancelMethod = tccTransaction.cancelMethod();
        String confirmMethod = tccTransaction.confirmMethod();
        Class executeClass = tccTransaction.executeClass();
        if (StringUtils.isEmpty((Object)tccTransaction.cancelMethod())) {
            cancelMethod = "cancel" + StringUtils.capitalize((String)method.getName());
        }
        if (StringUtils.isEmpty((Object)tccTransaction.confirmMethod())) {
            confirmMethod = "confirm" + StringUtils.capitalize((String)method.getName());
        }
        if (Void.class.isAssignableFrom(executeClass)) {
            executeClass = info.getTransactionInfo().getTargetClazz();
        }
        TCCTransactionInfo tccInfo = new TCCTransactionInfo();
        tccInfo.setExecuteClass(executeClass);
        tccInfo.setCancelMethod(cancelMethod);
        tccInfo.setConfirmMethod(confirmMethod);
        tccInfo.setMethodParameter(info.getTransactionInfo().getArgumentValues());
        tccInfo.setMethodTypeParameter(info.getTransactionInfo().getParameterTypes());
        return tccInfo;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) throws BeforeBusinessException {
        if (this.tccTransactionInfoCache.get(info.getUnitId()) == null) {
            this.tccTransactionInfoCache.putIfAbsent(info.getUnitId(), TccStartingTransaction.prepareTccInfo(info));
        }
        ((TCCTransactionInfo)this.tccTransactionInfoCache.get(info.getUnitId())).setMethodParameter(info.getTransactionInfo().getArgumentValues());
        this.transactionControlTemplate.createGroup(info.getGroupId(), info.getUnitId(), info.getTransactionInfo(), info.getTransactionType());
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        DTXLocal.cur().setSysTransactionState(0);
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) {
        DTXLocal.cur().setSysTransactionState(1);
    }

    @Override
    public void postBusinessCode(TxTransactionInfo info) {
        this.transactionControlTemplate.notifyGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), DTXLocal.transactionState());
    }
}

