/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.tcc.control;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TCCTransactionInfo;
import com.codingapi.txlcn.client.core.tcc.TccTransactionInfoCache;
import com.codingapi.txlcn.client.message.helper.TxMangerReporter;
import com.codingapi.txlcn.client.support.TransactionCleanService;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TccTransactionCleanService
implements TransactionCleanService {
    private static final Logger log = LoggerFactory.getLogger(TccTransactionCleanService.class);
    private final TransactionAttachmentCache transactionAttachmentCache;
    private final ApplicationContext applicationContext;
    private final TccTransactionInfoCache tccTransactionInfoCache;
    private final TxMangerReporter txMangerReporter;

    @Autowired
    public TccTransactionCleanService(TransactionAttachmentCache transactionAttachmentCache, ApplicationContext applicationContext, TccTransactionInfoCache tccTransactionInfoCache, TxMangerReporter txMangerReporter) {
        this.transactionAttachmentCache = transactionAttachmentCache;
        this.applicationContext = applicationContext;
        this.tccTransactionInfoCache = tccTransactionInfoCache;
        this.txMangerReporter = txMangerReporter;
    }

    @Override
    public void clear(String groupId, int state, String unitId, String unitType) throws TransactionClearException {
        TCCTransactionInfo tccInfo = (TCCTransactionInfo)this.tccTransactionInfoCache.get(unitId);
        Object object = this.applicationContext.getBean(tccInfo.getExecuteClass());
        Method exeMethod = null;
        try {
            if (Objects.isNull(DTXLocal.cur())) {
                DTXLocal.getOrNew().setJustNow(true);
            }
            DTXLocal.getOrNew().setGroupId(groupId);
            DTXLocal.cur().setUnitId(unitId);
            exeMethod = tccInfo.getExecuteClass().getMethod(state == 1 ? tccInfo.getConfirmMethod() : tccInfo.getCancelMethod(), tccInfo.getMethodTypeParameter());
            try {
                exeMethod.invoke(object, tccInfo.getMethodParameter());
            }
            catch (Throwable e) {
                log.error("tcc clean error.", e);
                this.txMangerReporter.reportTccCleanException(groupId, unitId, state);
            }
            this.transactionAttachmentCache.removeAttachments(groupId, unitId);
        }
        catch (Exception e) {
            log.error(" rpc_tcc_" + exeMethod + e.getMessage());
            throw new TransactionClearException(e.getMessage());
        }
        finally {
            if (DTXLocal.cur().isJustNow()) {
                DTXLocal.makeNeverAppeared();
            }
        }
    }
}

