/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.tcc.control;

import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.support.CustomizableTransactionSeparator;
import com.codingapi.txlcn.client.support.TXLCNTransactionState;
import com.codingapi.txlcn.client.support.TransactionUnitTypeList;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.commons.exception.TransactionException;
import com.codingapi.txlcn.spi.sleuth.TracerHelper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="transaction_state_resolver_tcc")
public class TccTypeTransactionSeparator
extends CustomizableTransactionSeparator {
    private static final Logger log = LoggerFactory.getLogger(TccTypeTransactionSeparator.class);
    private final TransactionAttachmentCache transactionAttachmentCache;
    private final TracerHelper tracerHelper;

    @Autowired
    public TccTypeTransactionSeparator(TransactionAttachmentCache transactionAttachmentCache, TracerHelper tracerHelper) {
        this.transactionAttachmentCache = transactionAttachmentCache;
        this.tracerHelper = tracerHelper;
    }

    @Override
    public TXLCNTransactionState loadTransactionState(TxTransactionInfo txTransactionInfo) throws TransactionException {
        if (this.tracerHelper.getGroupId() == null) {
            return super.loadTransactionState(txTransactionInfo);
        }
        Optional<TransactionUnitTypeList> sameTransUnitTypeList = this.transactionAttachmentCache.attachment(this.tracerHelper.getGroupId(), TransactionUnitTypeList.class);
        if (sameTransUnitTypeList.isPresent() && sameTransUnitTypeList.get().contains("lcn")) {
            throw new TransactionException("unsupported operate : TCC unit call TCC unit.");
        }
        return super.loadTransactionState(txTransactionInfo);
    }
}

