/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.control;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.RollbackInfo;
import com.codingapi.txlcn.client.support.TXLCNTransactionControl;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.client.support.template.TransactionControlTemplate;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.commons.exception.TxClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="control_txc_running")
public class TxcRunningTransaction
implements TXLCNTransactionControl {
    private static final Logger log = LoggerFactory.getLogger(TxcRunningTransaction.class);
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TransactionControlTemplate transactionControlTemplate;

    @Autowired
    public TxcRunningTransaction(TransactionCleanTemplate transactionCleanTemplate, TransactionControlTemplate transactionControlTemplate) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.transactionControlTemplate = transactionControlTemplate;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) {
        DTXLocal.cur().setAttachment(new RollbackInfo());
        DTXLocal.makeProxy();
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        try {
            log.info("txc > running > clean transaction.");
            this.transactionCleanTemplate.clean(DTXLocal.cur().getGroupId(), info.getUnitId(), info.getTransactionType(), 0);
        }
        catch (TransactionClearException e) {
            log.error("txc > Clean Transaction Error", (Throwable)e);
        }
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) throws TxClientException {
        this.transactionControlTemplate.joinGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), info.getTransactionInfo());
    }
}

