/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.control;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.RollbackInfo;
import com.codingapi.txlcn.client.support.TXLCNTransactionControl;
import com.codingapi.txlcn.client.support.template.TransactionControlTemplate;
import com.codingapi.txlcn.commons.exception.BeforeBusinessException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="control_txc_starting")
public class TxcStartingTransaction
implements TXLCNTransactionControl {
    private static final Logger log = LoggerFactory.getLogger(TxcStartingTransaction.class);
    private final TransactionControlTemplate transactionControlTemplate;

    @Autowired
    public TxcStartingTransaction(TransactionControlTemplate transactionControlTemplate) {
        this.transactionControlTemplate = transactionControlTemplate;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) throws BeforeBusinessException {
        try {
            this.transactionControlTemplate.createGroup(info.getGroupId(), info.getUnitId(), info.getTransactionInfo(), info.getTransactionType());
        }
        catch (Exception e) {
            throw new BeforeBusinessException((Throwable)e);
        }
        DTXLocal.cur().setAttachment(new RollbackInfo());
        DTXLocal.makeProxy();
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        DTXLocal.cur().setSysTransactionState(0);
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) {
        DTXLocal.cur().setSysTransactionState(1);
    }

    @Override
    public void postBusinessCode(TxTransactionInfo info) {
        RollbackInfo rollbackInfo = (RollbackInfo)DTXLocal.cur().getAttachment();
        int state = DTXLocal.transactionState();
        if (Objects.nonNull(rollbackInfo) && rollbackInfo.getStatus() < 0) {
            state = -1;
        }
        this.transactionControlTemplate.notifyGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), state);
    }
}

