/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.resource;

import com.codingapi.txlcn.client.core.txc.resource.TableStructAnalyser;
import com.codingapi.txlcn.client.core.txc.resource.TxcInitializer;
import com.codingapi.txlcn.client.core.txc.resource.TxcJdbcEventListener;
import com.codingapi.txlcn.client.core.txc.resource.TxcServiceImpl;
import com.codingapi.txlcn.client.core.txc.resource.TxcSqlExecuteInterceptor;
import com.codingapi.txlcn.client.core.txc.resource.TxcSqlExecutorImpl;
import com.codingapi.txlcn.client.core.txc.resource.def.SqlExecuteInterceptor;
import com.codingapi.txlcn.client.core.txc.resource.def.TxcService;
import com.codingapi.txlcn.client.core.txc.resource.def.TxcSqlExecutor;
import com.codingapi.txlcn.client.core.txc.resource.def.config.TxcConfig;
import com.codingapi.txlcn.client.core.txc.resource.init.TxcExceptionConnectionPool;
import com.codingapi.txlcn.client.core.txc.resource.init.TxcMysql;
import com.codingapi.txlcn.client.core.txc.resource.init.TxcSql;
import com.codingapi.txlcn.logger.TxLogger;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TxcConfiguration {
    @Bean
    public QueryRunner queryRunner(DataSource dataSource) {
        return new QueryRunner(dataSource);
    }

    @Bean
    public TxcExceptionConnectionPool txcExceptionConnectionPool(TxcConfig txcConfig) {
        return new TxcExceptionConnectionPool(txcConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public TxcSql txcLockSql() {
        return new TxcMysql();
    }

    @Bean
    public TableStructAnalyser tableStructAnalyser(DataSource dataSource) {
        return new TableStructAnalyser(dataSource);
    }

    @Bean
    public TxcSqlExecutor txcSqlExecutor(QueryRunner queryRunner, TxcSql txcSql, TxLogger txLogger) {
        return new TxcSqlExecutorImpl(queryRunner, txcSql, txLogger);
    }

    @Bean
    public TxcService txcService(TxcSqlExecutor txcSqlExecutor, TxcExceptionConnectionPool txcExceptionConnectionPool, TxLogger txLogger) {
        return new TxcServiceImpl(txcSqlExecutor, txcExceptionConnectionPool, txLogger);
    }

    @Bean
    public SqlExecuteInterceptor sqlExecuteInterceptor(TableStructAnalyser tableStructAnalyser, TxcService txcService) {
        return new TxcSqlExecuteInterceptor(tableStructAnalyser, txcService);
    }

    @Bean
    public TxcJdbcEventListener txcJdbcEventListener(SqlExecuteInterceptor sqlExecuteInterceptor) {
        return new TxcJdbcEventListener(sqlExecuteInterceptor);
    }

    @Bean
    public TxcInitializer txcInitializer() {
        return new TxcInitializer();
    }
}

