/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.resource;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.core.txc.resource.def.SqlExecuteInterceptor;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.LockableSelect;
import com.codingapi.txlcn.jdbcproxy.p6spy.common.PreparedStatementInformation;
import com.codingapi.txlcn.jdbcproxy.p6spy.common.StatementInformation;
import com.codingapi.txlcn.jdbcproxy.p6spy.event.P6spyJdbcEventListener;
import java.sql.SQLException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxcJdbcEventListener
extends P6spyJdbcEventListener {
    private static final Logger log = LoggerFactory.getLogger(TxcJdbcEventListener.class);
    private final SqlExecuteInterceptor sqlExecuteInterceptor;

    public TxcJdbcEventListener(SqlExecuteInterceptor sqlExecuteInterceptor) {
        this.sqlExecuteInterceptor = sqlExecuteInterceptor;
    }

    public String onBeforeAnyExecute(StatementInformation statementInformation) throws SQLException {
        String sql = statementInformation.getSqlWithValues();
        DTXLocal.cur().setResource(statementInformation.getStatement().getConnection());
        try {
            long startTime = System.currentTimeMillis();
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            log.debug("statement > {}", (Object)statement);
            statementInformation.setAttachment((Object)statement);
            if (statement instanceof Update) {
                this.sqlExecuteInterceptor.preUpdate((Update)statement);
            } else if (statement instanceof Delete) {
                this.sqlExecuteInterceptor.preDelete((Delete)statement);
            } else if (statement instanceof Insert) {
                this.sqlExecuteInterceptor.preInsert((Insert)statement);
            } else if (statement instanceof Select) {
                this.sqlExecuteInterceptor.preSelect(new LockableSelect((Select)statement));
            }
            log.debug("used time: {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (JSQLParserException e) {
            throw new SQLException(e);
        }
        return sql;
    }

    public void onAfterExecute(PreparedStatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        if (statementInformation.getAttachment() instanceof Insert) {
            try {
                this.sqlExecuteInterceptor.postInsert((StatementInformation)statementInformation);
            }
            catch (SQLException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public void onAfterExecute(StatementInformation statementInformation, long timeElapsedNanos, String sql, SQLException e) {
        if (statementInformation.getAttachment() instanceof Insert) {
            try {
                this.sqlExecuteInterceptor.postInsert(statementInformation);
            }
            catch (SQLException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public void onAfterExecuteUpdate(PreparedStatementInformation statementInformation, long timeElapsedNanos, int rowCount, SQLException e) {
        if (statementInformation.getAttachment() instanceof Insert) {
            try {
                this.sqlExecuteInterceptor.postInsert((StatementInformation)statementInformation);
            }
            catch (SQLException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public void onAfterExecuteUpdate(StatementInformation statementInformation, long timeElapsedNanos, String sql, int rowCount, SQLException e) {
        if (statementInformation.getAttachment() instanceof Insert) {
            try {
                this.sqlExecuteInterceptor.postInsert(statementInformation);
            }
            catch (SQLException e1) {
                throw new RuntimeException(e1);
            }
        }
    }
}

