/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.resource;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.core.txc.resource.def.TxcService;
import com.codingapi.txlcn.client.core.txc.resource.def.TxcSqlExecutor;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.DeleteImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.FieldCluster;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.FieldValue;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.InsertImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.LockInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.ModifiedRecord;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.RollbackInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.SelectImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.StatementInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.UndoLogDO;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.UpdateImageParams;
import com.codingapi.txlcn.client.core.txc.resource.init.TxcExceptionConnectionPool;
import com.codingapi.txlcn.client.core.txc.resource.util.SqlUtils;
import com.codingapi.txlcn.commons.exception.TxcLogicException;
import com.codingapi.txlcn.logger.TxLogger;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

public class TxcServiceImpl
implements TxcService {
    private static final Logger log = LoggerFactory.getLogger(TxcServiceImpl.class);
    private final TxcSqlExecutor txcSqlExecutor;
    private final TxcExceptionConnectionPool txcExceptionConnectionPool;
    private final TxLogger txLogger;

    public TxcServiceImpl(TxcSqlExecutor txcSqlExecutor, TxcExceptionConnectionPool txcExceptionConnectionPool, TxLogger txLogger) {
        this.txcSqlExecutor = txcSqlExecutor;
        this.txcExceptionConnectionPool = txcExceptionConnectionPool;
        this.txLogger = txLogger;
    }

    @Override
    public void lockResource(LockInfo lockInfo, RollbackInfo rollbackInfo) throws TxcLogicException {
        try {
            Connection connection = (Connection)DTXLocal.cur().getResource();
            lockInfo.setKeyValue(DigestUtils.md5DigestAsHex((byte[])lockInfo.getKeyValue().getBytes(StandardCharsets.UTF_8)));
            this.txcSqlExecutor.tryLock(connection, lockInfo);
        }
        catch (SQLException e) {
            rollbackInfo.setStatus(-1);
            throw new TxcLogicException("Resource is locked! Place try again later.");
        }
    }

    @Override
    public void lockSelect(SelectImageParams selectImageParams, boolean isxLock) throws TxcLogicException {
        Connection connection = (Connection)DTXLocal.cur().getResource();
        try {
            List<ModifiedRecord> modifiedRecords = this.txcSqlExecutor.selectSqlPreviousPrimaryKeys(connection, selectImageParams);
            for (ModifiedRecord modifiedRecord : modifiedRecords) {
                for (Map.Entry<String, FieldCluster> entry : modifiedRecord.getFieldClusters().entrySet()) {
                    String k = entry.getKey();
                    FieldCluster v = entry.getValue();
                    this.lockResource(new LockInfo().setGroupId(selectImageParams.getGroupId()).setUnitId(selectImageParams.getUnitId()).setxLock(isxLock).setKeyValue(v.getPrimaryKeys().toString()).setTableName(k), selectImageParams.getRollbackInfo());
                }
            }
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
    }

    @Override
    public void resolveUpdateImage(UpdateImageParams updateImageParams) throws TxcLogicException {
        List<ModifiedRecord> modifiedRecords;
        Connection connection = (Connection)DTXLocal.cur().getResource();
        try {
            modifiedRecords = this.txcSqlExecutor.updateSqlPreviousData(connection, updateImageParams);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
        for (ModifiedRecord modifiedRecord : modifiedRecords) {
            for (Map.Entry<String, FieldCluster> entry : modifiedRecord.getFieldClusters().entrySet()) {
                FieldValue fieldValue;
                String k = entry.getKey();
                FieldCluster v = entry.getValue();
                Object[] params = new Object[v.getFields().size() + v.getPrimaryKeys().size()];
                StringBuilder rollbackSql = new StringBuilder().append("UPDATE ").append(k).append(" SET ");
                int index = 0;
                int i = 0;
                while (i < v.getFields().size()) {
                    fieldValue = v.getFields().get(i);
                    rollbackSql.append(fieldValue.getFieldName()).append("=?").append(", ");
                    params[index] = fieldValue.getValue();
                    ++i;
                    ++index;
                }
                SqlUtils.cutSuffix(", ", rollbackSql);
                rollbackSql.append(" WHERE ");
                i = 0;
                while (i < v.getPrimaryKeys().size()) {
                    fieldValue = v.getPrimaryKeys().get(i);
                    rollbackSql.append(fieldValue.getFieldName()).append("=?").append(" and ");
                    params[index] = fieldValue.getValue();
                    ++i;
                    ++index;
                }
                SqlUtils.cutSuffix(" and ", rollbackSql);
                StatementInfo statementInfo = new StatementInfo(rollbackSql.toString(), params);
                updateImageParams.getRollbackInfo().getRollbackSqlList().add(statementInfo);
                UndoLogDO undoLogDO = new UndoLogDO();
                undoLogDO.setGroupId(updateImageParams.getGroupId());
                undoLogDO.setUnitId(updateImageParams.getUnitId());
                undoLogDO.setRollbackInfo(SqlUtils.objectToBlob(statementInfo));
                undoLogDO.setGmtCreate(System.currentTimeMillis());
                undoLogDO.setGmtModified(System.currentTimeMillis());
                try {
                    this.txcSqlExecutor.writeUndoLogByGivenConnection(connection, undoLogDO);
                }
                catch (SQLException e) {
                    throw new TxcLogicException((Throwable)e);
                }
                this.lockResource(new LockInfo().setxLock(true).setKeyValue(v.getPrimaryKeys().toString()).setGroupId(updateImageParams.getGroupId()).setUnitId(updateImageParams.getUnitId()).setTableName(k), updateImageParams.getRollbackInfo());
            }
        }
        log.debug("rollback info: {}", (Object)updateImageParams.getRollbackInfo());
    }

    @Override
    public void resolveDeleteImage(DeleteImageParams deleteImageParams) throws TxcLogicException {
        List<ModifiedRecord> modifiedRecords;
        Connection connection = (Connection)DTXLocal.cur().getResource();
        try {
            modifiedRecords = this.txcSqlExecutor.deleteSqlPreviousData(connection, deleteImageParams);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
        for (ModifiedRecord modifiedRecord : modifiedRecords) {
            for (Map.Entry<String, FieldCluster> entry : modifiedRecord.getFieldClusters().entrySet()) {
                String k = entry.getKey();
                FieldCluster v = entry.getValue();
                StringBuilder rollbackSql = new StringBuilder("INSERT INTO ").append(k).append('(');
                StringBuilder values = new StringBuilder();
                Object[] params = new Object[v.getFields().size()];
                for (int i = 0; i < v.getFields().size(); ++i) {
                    FieldValue fieldValue = v.getFields().get(i);
                    rollbackSql.append(fieldValue.getFieldName()).append(", ");
                    values.append("?, ");
                    params[i] = fieldValue.getValue();
                }
                SqlUtils.cutSuffix(", ", rollbackSql);
                SqlUtils.cutSuffix(", ", values);
                rollbackSql.append(") values(").append((CharSequence)values).append(')');
                StatementInfo statementInfo = new StatementInfo(rollbackSql.toString(), params);
                deleteImageParams.getRollbackInfo().getRollbackSqlList().add(statementInfo);
                UndoLogDO undoLogDO = new UndoLogDO();
                undoLogDO.setGmtCreate(System.currentTimeMillis());
                undoLogDO.setGmtModified(System.currentTimeMillis());
                undoLogDO.setGroupId(deleteImageParams.getGroupId());
                undoLogDO.setUnitId(deleteImageParams.getUnitId());
                undoLogDO.setRollbackInfo(SqlUtils.objectToBlob(statementInfo));
                try {
                    this.txcSqlExecutor.writeUndoLogByGivenConnection(connection, undoLogDO);
                }
                catch (SQLException e) {
                    throw new TxcLogicException((Throwable)e);
                }
                this.lockResource(new LockInfo().setxLock(true).setGroupId(deleteImageParams.getGroupId()).setUnitId(deleteImageParams.getUnitId()).setKeyValue(v.getPrimaryKeys().toString()).setTableName(k), deleteImageParams.getRollbackInfo());
            }
        }
    }

    @Override
    public void writeUndoLog(String groupId, String unitId, RollbackInfo rollbackInfo) throws TxcLogicException {
        if (rollbackInfo.getRollbackSqlList().size() == 0) {
            return;
        }
        UndoLogDO undoLogDO = new UndoLogDO();
        undoLogDO.setGroupId(groupId);
        undoLogDO.setUnitId(unitId);
        undoLogDO.setRollbackInfo(SqlUtils.objectToBlob(rollbackInfo));
        try {
            DTXLocal.makeUnProxy();
            this.txcSqlExecutor.writeUndoLog(undoLogDO);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
        finally {
            DTXLocal.undoProxyStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanTxc(String groupId, String unitId) throws TxcLogicException {
        try {
            DTXLocal.makeUnProxy();
            this.txcSqlExecutor.clearLock(groupId, unitId);
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 1146) {
                throw new TxcLogicException((Throwable)e);
            }
        }
        finally {
            DTXLocal.undoProxyStatus();
        }
        try {
            DTXLocal.makeUnProxy();
            this.txcSqlExecutor.clearUndoLog(groupId, unitId);
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 1146) {
                throw new TxcLogicException((Throwable)e);
            }
        }
        finally {
            DTXLocal.undoProxyStatus();
        }
    }

    @Override
    public void undo(String groupId, String unitId) throws TxcLogicException {
        RollbackInfo rollbackInfo;
        if (Objects.nonNull(DTXLocal.cur()) && Objects.nonNull(rollbackInfo = (RollbackInfo)DTXLocal.cur().getAttachment())) {
            this.txLogger.trace(groupId, unitId, "transaction", "rollback by txEx pool.");
            Connection connection = null;
            try {
                connection = this.txcExceptionConnectionPool.getConnection();
                this.txcSqlExecutor.undoRollbackInfoSql(connection, rollbackInfo);
                return;
            }
            catch (SQLException e1) {
                throw new TxcLogicException((Throwable)e1);
            }
            finally {
                try {
                    DbUtils.close((Connection)connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        try {
            DTXLocal.makeUnProxy();
            this.txcSqlExecutor.applyUndoLog(groupId, unitId);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
        finally {
            DTXLocal.undoProxyStatus();
        }
    }

    @Override
    public void resolveInsertImage(InsertImageParams insertImageParams) throws TxcLogicException {
        Connection connection = (Connection)DTXLocal.cur().getResource();
        Object[] paramArray = insertImageParams.getParams().toArray(new Object[0]);
        StatementInfo statementInfo = new StatementInfo(insertImageParams.getRollbackSql(), paramArray);
        insertImageParams.getRollbackInfo().getRollbackSqlList().add(statementInfo);
        UndoLogDO undoLogDO = new UndoLogDO();
        undoLogDO.setGmtCreate(System.currentTimeMillis());
        undoLogDO.setGmtModified(System.currentTimeMillis());
        undoLogDO.setRollbackInfo(SqlUtils.objectToBlob(statementInfo));
        undoLogDO.setGroupId(insertImageParams.getGroupId());
        undoLogDO.setUnitId(insertImageParams.getUnitId());
        try {
            this.txcSqlExecutor.writeUndoLogByGivenConnection(connection, undoLogDO);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
    }
}

