/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.resource;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.core.txc.resource.PrimaryKeyListVisitor;
import com.codingapi.txlcn.client.core.txc.resource.TableStructAnalyser;
import com.codingapi.txlcn.client.core.txc.resource.def.SqlExecuteInterceptor;
import com.codingapi.txlcn.client.core.txc.resource.def.TxcService;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.DeleteImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.InsertImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.LockableSelect;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.RollbackInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.SelectImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.TableStruct;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.UpdateImageParams;
import com.codingapi.txlcn.client.core.txc.resource.util.SqlUtils;
import com.codingapi.txlcn.commons.exception.TxcLogicException;
import com.codingapi.txlcn.jdbcproxy.p6spy.common.StatementInformation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxcSqlExecuteInterceptor
implements SqlExecuteInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TxcSqlExecuteInterceptor.class);
    private final TableStructAnalyser tableStructAnalyser;
    private final TxcService txcService;

    public TxcSqlExecuteInterceptor(TableStructAnalyser tableStructAnalyser, TxcService txcService) {
        this.tableStructAnalyser = tableStructAnalyser;
        this.txcService = txcService;
    }

    @Override
    public void preUpdate(Update update) throws SQLException {
        String groupId = DTXLocal.cur().getGroupId();
        String unitId = DTXLocal.cur().getUnitId();
        RollbackInfo rollbackInfo = (RollbackInfo)DTXLocal.cur().getAttachment();
        Connection connection = (Connection)DTXLocal.cur().getResource();
        ArrayList<String> columns = new ArrayList<String>(update.getColumns().size());
        ArrayList<String> primaryKeys = new ArrayList<String>(3);
        ArrayList<String> tables = new ArrayList<String>(update.getTables().size());
        update.getColumns().forEach(column -> {
            column.setTable((Table)update.getTables().get(0));
            columns.add(column.getFullyQualifiedName());
        });
        for (Table table : update.getTables()) {
            tables.add(table.getName());
            TableStruct tableStruct = this.tableStructAnalyser.analyse(connection, table.getName());
            tableStruct.getPrimaryKeys().forEach(key -> primaryKeys.add(table.getName() + "." + key));
        }
        try {
            this.txcService.resolveUpdateImage(new UpdateImageParams().setGroupId(groupId).setUnitId(unitId).setRollbackInfo(rollbackInfo).setColumns(columns).setPrimaryKeys(primaryKeys).setTables(tables).setWhereSql(update.getWhere() == null ? "1=1" : update.getWhere().toString()));
        }
        catch (TxcLogicException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void preDelete(Delete delete) throws SQLException {
        log.debug("do pre delete: {}", (Object)delete);
        RollbackInfo rollbackInfo = (RollbackInfo)DTXLocal.cur().getAttachment();
        String groupId = DTXLocal.cur().getGroupId();
        String unitId = DTXLocal.cur().getUnitId();
        Connection connection = (Connection)DTXLocal.cur().getResource();
        if (delete.getTables().size() == 0) {
            delete.setTables(Collections.singletonList(delete.getTable()));
        }
        ArrayList<String> tables = new ArrayList<String>(delete.getTables().size());
        ArrayList<String> primaryKeys = new ArrayList<String>(3);
        ArrayList<String> columns = new ArrayList<String>();
        for (Table table : delete.getTables()) {
            TableStruct tableStruct = this.tableStructAnalyser.analyse(connection, table.getName());
            tableStruct.getColumns().forEach((k, v) -> columns.add(tableStruct.getTableName() + "." + k));
            tableStruct.getPrimaryKeys().forEach(primaryKey -> primaryKeys.add(tableStruct.getTableName() + "." + primaryKey));
            tables.add(tableStruct.getTableName());
        }
        try {
            this.txcService.resolveDeleteImage(new DeleteImageParams().setGroupId(groupId).setUnitId(unitId).setRollbackInfo(rollbackInfo).setSqlWhere(delete.getWhere().toString()).setColumns(columns).setPrimaryKeys(primaryKeys).setTables(tables));
        }
        catch (TxcLogicException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void preInsert(Insert insert) {
    }

    @Override
    public void postInsert(StatementInformation statementInformation) throws SQLException {
        String groupId = DTXLocal.cur().getGroupId();
        String unitId = DTXLocal.cur().getUnitId();
        Connection connection = (Connection)DTXLocal.cur().getResource();
        Insert insert = (Insert)statementInformation.getAttachment();
        TableStruct tableStruct = this.tableStructAnalyser.analyse(connection, insert.getTable().getName());
        PrimaryKeyListVisitor primaryKeyListVisitor = new PrimaryKeyListVisitor(insert.getTable(), insert.getColumns(), tableStruct.getFullyQualifiedPrimaryKeys());
        insert.getItemsList().accept((ItemsListVisitor)primaryKeyListVisitor);
        ResultSet rs = statementInformation.getStatement().getGeneratedKeys();
        StringBuilder rollbackSql = new StringBuilder("DELETE ").append(" FROM ").append(tableStruct.getTableName()).append(" WHERE ");
        ArrayList<Object> params = new ArrayList<Object>();
        int i = 0;
        while (rs.next()) {
            Map<String, Object> pks = primaryKeyListVisitor.getPrimaryKeyValuesList().get(i);
            for (String key : tableStruct.getFullyQualifiedPrimaryKeys()) {
                rollbackSql.append(key).append("=? and ");
                if (pks.containsKey(key)) {
                    params.add(pks.get(key));
                    continue;
                }
                params.add(rs.getObject(1));
            }
            SqlUtils.cutSuffix(" and ", rollbackSql);
            rollbackSql.append(" or ");
            ++i;
        }
        DbUtils.close((ResultSet)rs);
        SqlUtils.cutSuffix(" or ", rollbackSql);
        if (params.size() == 0) {
            log.warn("nothing to insert");
            return;
        }
        RollbackInfo rollbackInfo = (RollbackInfo)DTXLocal.cur().getAttachment();
        try {
            this.txcService.resolveInsertImage(new InsertImageParams(groupId, unitId, rollbackSql.toString(), params, rollbackInfo));
        }
        catch (TxcLogicException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void preSelect(LockableSelect lockableSelect) throws SQLException {
        if (!lockableSelect.shouldLock()) {
            return;
        }
        if (!(lockableSelect.statement().getSelectBody() instanceof PlainSelect)) {
            throw new SQLException("non support this query when use control lock.");
        }
        PlainSelect plainSelect = (PlainSelect)lockableSelect.statement().getSelectBody();
        if (!(plainSelect.getFromItem() instanceof Table)) {
            throw new SQLException("non support this query when use control lock.");
        }
        ArrayList<String> primaryKeys = new ArrayList<String>();
        Table leftTable = (Table)plainSelect.getFromItem();
        ArrayList selectItems = new ArrayList();
        Connection connection = (Connection)DTXLocal.cur().getResource();
        TableStruct leftTableStruct = this.tableStructAnalyser.analyse(connection, leftTable.getName());
        leftTableStruct.getPrimaryKeys().forEach(primaryKey -> {
            Column column = new Column(leftTable, primaryKey);
            selectItems.add(new SelectExpressionItem((Expression)column));
            primaryKeys.add(column.getFullyQualifiedName());
        });
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                if (!join.isSimple()) continue;
                TableStruct rightTableStruct = this.tableStructAnalyser.analyse(connection, join.getRightItem().toString());
                rightTableStruct.getPrimaryKeys().forEach(primaryKey -> {
                    Column column = new Column((Table)join.getRightItem(), primaryKey);
                    selectItems.add(new SelectExpressionItem((Expression)column));
                    primaryKeys.add(column.getFullyQualifiedName());
                });
            }
        }
        plainSelect.setSelectItems(selectItems);
        log.info("lock select sql: {}", (Object)plainSelect);
        String groupId = DTXLocal.cur().getGroupId();
        String unitId = DTXLocal.cur().getUnitId();
        RollbackInfo rollbackInfo = (RollbackInfo)DTXLocal.cur().getAttachment();
        SelectImageParams selectImageParams = new SelectImageParams();
        selectImageParams.setGroupId(groupId);
        selectImageParams.setUnitId(unitId);
        selectImageParams.setPrimaryKeys(primaryKeys);
        selectImageParams.setRollbackInfo(rollbackInfo);
        selectImageParams.setSql(plainSelect.toString());
        try {
            this.txcService.lockSelect(selectImageParams, lockableSelect.isxLock());
        }
        catch (TxcLogicException e) {
            throw new SQLException(e.getMessage());
        }
    }
}

