/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.resource;

import com.codingapi.txlcn.client.core.txc.resource.def.TxcSqlExecutor;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.DeleteImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.LockInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.ModifiedRecord;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.RollbackInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.SelectImageParams;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.StatementInfo;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.UndoLogDO;
import com.codingapi.txlcn.client.core.txc.resource.def.bean.UpdateImageParams;
import com.codingapi.txlcn.client.core.txc.resource.init.TxcSql;
import com.codingapi.txlcn.client.core.txc.resource.rs.UpdateSqlPreDataHandler;
import com.codingapi.txlcn.client.core.txc.resource.util.SqlUtils;
import com.codingapi.txlcn.logger.TxLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TxcSqlExecutorImpl
implements TxcSqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(TxcSqlExecutorImpl.class);
    private final QueryRunner queryRunner;
    private final TxcSql txcSql;
    private final TxLogger txLogger;

    @Autowired
    public TxcSqlExecutorImpl(QueryRunner queryRunner, TxcSql txcSql, TxLogger txLogger) {
        this.queryRunner = queryRunner;
        this.txcSql = txcSql;
        this.txLogger = txLogger;
    }

    @Override
    public void createLockTable() {
        try {
            this.queryRunner.execute(this.txcSql.lockTableSql(), new Object[0]);
        }
        catch (SQLException e) {
            log.error("txc > sql executor > create lock table error.", (Throwable)e);
        }
    }

    @Override
    public void createUndoLogTable() {
        try {
            this.queryRunner.execute(this.txcSql.undoLogTableSql(), new Object[0]);
        }
        catch (SQLException e) {
            log.error("txc > sql executor > create undo_log table error.", (Throwable)e);
        }
    }

    @Override
    public List<ModifiedRecord> updateSqlPreviousData(Connection connection, UpdateImageParams updateImageParams) throws SQLException {
        String beforeSql = "SELECT " + String.join((CharSequence)", ", updateImageParams.getColumns()) + ", " + String.join((CharSequence)", ", updateImageParams.getPrimaryKeys()) + " FROM " + String.join((CharSequence)", ", updateImageParams.getTables()) + " WHERE " + updateImageParams.getWhereSql();
        return (List)this.queryRunner.query(connection, beforeSql, (ResultSetHandler)new UpdateSqlPreDataHandler(updateImageParams.getPrimaryKeys(), updateImageParams.getColumns()));
    }

    @Override
    public List<ModifiedRecord> deleteSqlPreviousData(Connection connection, DeleteImageParams deleteImageParams) throws SQLException {
        String beforeSql = "SELECT " + String.join((CharSequence)", ", deleteImageParams.getColumns()) + " FROM " + String.join((CharSequence)", ", deleteImageParams.getTables()) + " WHERE " + deleteImageParams.getSqlWhere();
        return (List)this.queryRunner.query(connection, beforeSql, (ResultSetHandler)new UpdateSqlPreDataHandler(deleteImageParams.getPrimaryKeys(), deleteImageParams.getColumns()));
    }

    @Override
    public List<ModifiedRecord> selectSqlPreviousPrimaryKeys(Connection connection, SelectImageParams selectImageParams) throws SQLException {
        return (List)this.queryRunner.query(connection, selectImageParams.getSql(), (ResultSetHandler)new UpdateSqlPreDataHandler(selectImageParams.getPrimaryKeys(), selectImageParams.getPrimaryKeys()));
    }

    @Override
    public void tryLock(Connection connection, LockInfo lockInfo) throws SQLException {
        String lockSql = "INSERT INTO `" + this.txcSql.lockTableName() + "` (table_name, key_value, group_id, unit_id, x_lock, s_lock) values(?, ?, ?, ?, ?, ?)";
        this.queryRunner.insert(connection, lockSql, (ResultSetHandler)new ScalarHandler(), new Object[]{lockInfo.getTableName(), lockInfo.getKeyValue(), lockInfo.getGroupId(), lockInfo.getUnitId(), lockInfo.isXLock() ? Integer.valueOf(1) : null, lockInfo.isXLock() ? null : Integer.valueOf(1)});
    }

    @Override
    public void clearLock(String groupId, String unitId) throws SQLException {
        log.debug("txc > sql > executor > clear lock. groupId: {}, unitId: {}", (Object)groupId, (Object)unitId);
        String cleanLockSql = "DELETE FROM `" + this.txcSql.lockTableName() + "` where group_id = ? and unit_id = ?";
        this.queryRunner.update(cleanLockSql, new Object[]{groupId, unitId});
    }

    @Override
    public void writeUndoLog(UndoLogDO undoLogDo) throws SQLException {
        Connection connection = this.queryRunner.getDataSource().getConnection();
        this.writeUndoLogByGivenConnection(connection, undoLogDo);
        DbUtils.close((Connection)connection);
    }

    @Override
    public void writeUndoLogByGivenConnection(Connection connection, UndoLogDO undoLogDo) throws SQLException {
        log.debug("txc > write undo log. params: {}", (Object)undoLogDo);
        this.txLogger.trace(undoLogDo.getGroupId(), undoLogDo.getUnitId(), "txc", "write undo log before. groupId: " + undoLogDo.getGroupId() + ", unitId: " + undoLogDo.getUnitId());
        String undoLogSql = "INSERT INTO `" + this.txcSql.undoLogTableName() + "`(gmt_create, gmt_modified, group_id, unit_id, rollback_info) values(?, ?, ?, ?, ?)";
        long count = (Long)this.queryRunner.insert(connection, undoLogSql, (ResultSetHandler)new ScalarHandler(), new Object[]{undoLogDo.getGmtCreate(), undoLogDo.getGmtModified(), undoLogDo.getGroupId(), undoLogDo.getUnitId(), undoLogDo.getRollbackInfo()});
        this.txLogger.trace(undoLogDo.getGroupId(), undoLogDo.getUnitId(), "txc", "write undo log. log id: " + count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyUndoLog(String groupId, String unitId) throws SQLException {
        List undoLogDOList;
        Connection connection;
        block9: {
            log.debug("txc > execute undo log. groupId: {}, unitId: {}", (Object)groupId, (Object)unitId);
            String undoLogSql = "SELECT rollback_info FROM `" + this.txcSql.undoLogTableName() + "` WHERE `group_id`=? and `unit_id`=?";
            connection = null;
            try {
                undoLogDOList = (List)this.queryRunner.query(undoLogSql, rs -> {
                    ArrayList<StatementInfo> list = new ArrayList<StatementInfo>();
                    while (rs.next()) {
                        list.add(SqlUtils.blobToObject(rs.getBytes(1), StatementInfo.class));
                    }
                    return list;
                }, new Object[]{groupId, unitId});
                this.txLogger.trace(groupId, unitId, "txc", "undoLogDo sql " + undoLogDOList);
                if (!undoLogDOList.isEmpty()) break block9;
                log.warn("txc . undo log not found!");
                this.txLogger.trace(groupId, unitId, "txc", "undo log not found!");
            }
            catch (Throwable throwable) {
                try {
                    DbUtils.close(connection);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                DbUtils.close(connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return;
        }
        RollbackInfo rollbackInfo = new RollbackInfo();
        rollbackInfo.setRollbackSqlList(undoLogDOList);
        this.txLogger.trace(groupId, unitId, "txc", "rollbackInfo sql " + rollbackInfo.toString());
        connection = this.queryRunner.getDataSource().getConnection();
        this.undoRollbackInfoSql(connection, rollbackInfo);
        try {
            DbUtils.close((Connection)connection);
        }
        catch (SQLException sQLException) {}
    }

    @Override
    public void undoRollbackInfoSql(Connection connection, RollbackInfo rollbackInfo) throws SQLException {
        try {
            connection.setAutoCommit(false);
            for (StatementInfo statementInfo : rollbackInfo.getRollbackSqlList()) {
                log.debug("txc > Apply undo log. sql: {}, params: {}", (Object)statementInfo.getSql(), (Object)statementInfo.getParams());
                this.queryRunner.update(connection, statementInfo.getSql(), statementInfo.getParams());
            }
            connection.commit();
        }
        catch (SQLException e) {
            DbUtils.rollback((Connection)connection);
            throw e;
        }
        finally {
            connection.setAutoCommit(true);
        }
    }

    @Override
    public void clearUndoLog(String groupId, String unitId) throws SQLException {
        log.debug("txc > clear undo log. groupId: {}, unitId: {}", (Object)groupId, (Object)unitId);
        this.txLogger.trace(groupId, unitId, "txc", "clear undo log");
        String cleanUndoLogSql = "DELETE FROM `" + this.txcSql.undoLogTableName() + "` WHERE group_id = ? and unit_id = ?";
        this.queryRunner.update(cleanUndoLogSql, new Object[]{groupId, unitId});
    }
}

