/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.core.txc.resource.def.config;

import com.zaxxer.hikari.HikariConfig;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="tx-lcn.client.txc")
@Component
public class TxcConfig
extends HikariConfig {
    private static final Logger log = LoggerFactory.getLogger(TxcConfig.class);

    @Autowired(required=false)
    public TxcConfig(DataSourceProperties dataSourceProperties) {
        if (Objects.isNull(dataSourceProperties) || Objects.isNull(dataSourceProperties.getDriverClassName()) || Objects.isNull(dataSourceProperties.getUrl())) {
            log.info("TXC Mode Bak-Connection-Pool used user's config.");
            return;
        }
        this.setDriverClassName(dataSourceProperties.getDriverClassName());
        this.setJdbcUrl(dataSourceProperties.getUrl());
        this.setUsername(dataSourceProperties.getUsername());
        this.setPassword(dataSourceProperties.getPassword());
        this.setMinimumIdle(10);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxcConfig)) {
            return false;
        }
        TxcConfig other = (TxcConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxcConfig;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "TxcConfig()";
    }
}

