/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.initializer;

import com.codingapi.txlcn.client.aspectlog.AspectLogHelper;
import com.codingapi.txlcn.client.message.TXLCNClientMessageServer;
import com.codingapi.txlcn.client.support.checking.DTXChecking;
import com.codingapi.txlcn.client.support.checking.SimpleDTXChecking;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.commons.runner.TxLcnInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TxClientInitializer
implements TxLcnInitializer {
    private final AspectLogHelper aspectLogHelper;
    private final TXLCNClientMessageServer txLcnClientMessageServer;
    private final DTXChecking dtxChecking;
    private final TransactionCleanTemplate transactionCleanTemplate;

    @Autowired
    public TxClientInitializer(AspectLogHelper aspectLogHelper, TXLCNClientMessageServer txLcnClientMessageServer, DTXChecking dtxChecking, TransactionCleanTemplate transactionCleanTemplate) {
        this.aspectLogHelper = aspectLogHelper;
        this.txLcnClientMessageServer = txLcnClientMessageServer;
        this.dtxChecking = dtxChecking;
        this.transactionCleanTemplate = transactionCleanTemplate;
    }

    public void init() throws Exception {
        this.aspectLogHelper.init();
        this.txLcnClientMessageServer.init();
        this.dtxCheckingTransactionCleanTemplateAdapt();
    }

    private void dtxCheckingTransactionCleanTemplateAdapt() {
        if (this.dtxChecking instanceof SimpleDTXChecking) {
            ((SimpleDTXChecking)this.dtxChecking).setTransactionCleanTemplate(this.transactionCleanTemplate);
        }
    }
}

