/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.message;

import com.codingapi.txlcn.client.aspectlog.AspectLog;
import com.codingapi.txlcn.client.aspectlog.AspectLogHelper;
import com.codingapi.txlcn.client.message.helper.RpcExecuteService;
import com.codingapi.txlcn.client.message.helper.TransactionCmd;
import com.codingapi.txlcn.commons.bean.TransactionInfo;
import com.codingapi.txlcn.commons.exception.SerializerException;
import com.codingapi.txlcn.commons.exception.TxClientException;
import com.codingapi.txlcn.commons.util.serializer.SerializerContext;
import com.codingapi.txlcn.spi.message.params.GetAspectLogParams;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpc_get-aspect-log")
public class GetAspectLogService
implements RpcExecuteService {
    private final AspectLogHelper txLogHelper;

    @Autowired
    public GetAspectLogService(AspectLogHelper txLogHelper) {
        this.txLogHelper = txLogHelper;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxClientException {
        try {
            GetAspectLogParams getAspectLogParams = (GetAspectLogParams)transactionCmd.getMsg().loadBean(GetAspectLogParams.class);
            AspectLog txLog = this.txLogHelper.getTxLog(getAspectLogParams.getGroupId(), getAspectLogParams.getUnitId());
            if (Objects.isNull(txLog)) {
                throw new TxClientException("non exists aspect log.");
            }
            TransactionInfo transactionInfo = (TransactionInfo)SerializerContext.getInstance().deSerialize(txLog.getBytes(), TransactionInfo.class);
            return transactionInfo.toJsonObject();
        }
        catch (SerializerException e) {
            throw new TxClientException((Throwable)e);
        }
    }
}

