/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.message;

import com.codingapi.txlcn.client.message.helper.RpcExecuteService;
import com.codingapi.txlcn.client.message.helper.TransactionCmd;
import com.codingapi.txlcn.commons.exception.TxClientException;
import com.codingapi.txlcn.spi.message.RpcClientInitializer;
import com.codingapi.txlcn.spi.message.params.NotifyConnectParams;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_notify-connect")
public class RpcNotifyConnectService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(RpcNotifyConnectService.class);
    private final RpcClientInitializer rpcClientInitializer;

    @Autowired
    public RpcNotifyConnectService(RpcClientInitializer rpcClientInitializer) {
        this.rpcClientInitializer = rpcClientInitializer;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxClientException {
        log.info("transactionCmd->{}", (Object)transactionCmd);
        NotifyConnectParams notifyConnectParams = (NotifyConnectParams)transactionCmd.getMsg().loadBean(NotifyConnectParams.class);
        this.rpcClientInitializer.connect((SocketAddress)new InetSocketAddress(notifyConnectParams.getHost(), notifyConnectParams.getPort()));
        return null;
    }
}

