/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.message.helper;

import com.codingapi.txlcn.client.message.helper.MessageCreator;
import com.codingapi.txlcn.client.message.helper.MessageParser;
import com.codingapi.txlcn.client.message.helper.RpcExecuteService;
import com.codingapi.txlcn.client.message.helper.TransactionCmd;
import com.codingapi.txlcn.client.support.TXLCNTransactionBeanHelper;
import com.codingapi.txlcn.commons.exception.TxClientException;
import com.codingapi.txlcn.spi.message.RpcAnswer;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientRpcAnswer
implements RpcAnswer {
    private static final Logger log = LoggerFactory.getLogger(ClientRpcAnswer.class);
    private final TXLCNTransactionBeanHelper transactionBeanHelper;
    private final RpcClient rpcClient;

    @Autowired
    public ClientRpcAnswer(TXLCNTransactionBeanHelper transactionBeanHelper, RpcClient rpcClient) {
        this.transactionBeanHelper = transactionBeanHelper;
        this.rpcClient = rpcClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback(RpcCmd rpcCmd) {
        log.debug("Receive Message: {}", (Object)rpcCmd.getMsg());
        TransactionCmd transactionCmd = MessageParser.parser(rpcCmd);
        String transactionType = transactionCmd.getTransactionType();
        String action = transactionCmd.getMsg().getAction();
        RpcExecuteService executeService = this.transactionBeanHelper.loadRpcExecuteService(transactionType, transactionCmd.getType());
        MessageDto messageDto = null;
        try {
            Serializable message = executeService.execute(transactionCmd);
            messageDto = MessageCreator.notifyUnitOkResponse(message, action);
        }
        catch (TxClientException e) {
            log.error("message > execute error.", (Throwable)e);
            messageDto = MessageCreator.notifyUnitFailResponse((Serializable)((Object)e), action);
        }
        finally {
            if (Objects.nonNull(rpcCmd.getKey())) {
                try {
                    rpcCmd.setMsg(messageDto);
                    this.rpcClient.send(rpcCmd);
                }
                catch (RpcException e) {
                    log.error("response request[{}] error. error message: {}", (Object)rpcCmd.getKey(), (Object)e.getMessage());
                }
            }
        }
    }
}

