/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.message.helper;

import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.params.AskTransactionStateParams;
import com.codingapi.txlcn.spi.message.params.InitClientParams;
import com.codingapi.txlcn.spi.message.params.JoinGroupParams;
import com.codingapi.txlcn.spi.message.params.NotifyGroupParams;
import com.codingapi.txlcn.spi.message.params.TxExceptionParams;
import java.io.Serializable;

public class MessageCreator {
    public static MessageDto createGroup(String groupId) {
        MessageDto msg = new MessageDto();
        msg.setGroupId(groupId);
        msg.setAction("createGroup");
        return msg;
    }

    public static MessageDto joinGroup(JoinGroupParams joinGroupParams) {
        MessageDto msg = new MessageDto();
        msg.setGroupId(joinGroupParams.getGroupId());
        msg.setAction("joinGroup");
        msg.setData((Serializable)joinGroupParams);
        return msg;
    }

    public static MessageDto notifyGroup(NotifyGroupParams notifyGroupParams) {
        MessageDto msg = new MessageDto();
        msg.setGroupId(notifyGroupParams.getGroupId());
        msg.setAction("notifyGroup");
        msg.setData((Serializable)notifyGroupParams);
        return msg;
    }

    public static MessageDto notifyUnitOkResponse(Serializable message, String action) {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction(action);
        messageDto.setState(200);
        messageDto.setData(message);
        return messageDto;
    }

    public static MessageDto notifyUnitFailResponse(Serializable message, String action) {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction(action);
        messageDto.setState(500);
        messageDto.setData(message);
        return messageDto;
    }

    public static MessageDto askTransactionState(String groupId, String unitId) {
        MessageDto messageDto = new MessageDto();
        messageDto.setGroupId(groupId);
        messageDto.setAction("askTransactionState");
        messageDto.setData((Serializable)new AskTransactionStateParams(groupId, unitId));
        return messageDto;
    }

    public static MessageDto writeTxException(TxExceptionParams txExceptionParams) {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("writeException");
        messageDto.setGroupId(txExceptionParams.getGroupId());
        messageDto.setData((Serializable)txExceptionParams);
        return messageDto;
    }

    public static MessageDto initClient(String appName) {
        InitClientParams initClientParams = new InitClientParams();
        initClientParams.setAppName(appName);
        MessageDto messageDto = new MessageDto();
        messageDto.setGroupId("INITCLIENTGROUPID");
        messageDto.setData((Serializable)initClientParams);
        messageDto.setAction("initClient");
        return messageDto;
    }
}

