/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.message.helper;

import com.codingapi.txlcn.client.message.helper.MessageCreator;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.params.TxExceptionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TxMangerReporter {
    private static final Logger log = LoggerFactory.getLogger(TxMangerReporter.class);
    private final RpcClient rpcClient;
    private static final String REPORT_ERROR_MESSAGE = "report transaction transactionState error";

    @Autowired
    public TxMangerReporter(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public void reportTransactionState(String groupId, String unitId, Short registrar, int state) {
        TxExceptionParams txExceptionParams = new TxExceptionParams();
        txExceptionParams.setGroupId(groupId);
        txExceptionParams.setRegistrar(registrar);
        txExceptionParams.setTransactionState(Integer.valueOf(state));
        txExceptionParams.setUnitId(unitId);
        this.report(txExceptionParams);
    }

    public void reportTccCleanException(String groupId, String unitId, int state) {
        TxExceptionParams txExceptionParams = new TxExceptionParams();
        txExceptionParams.setGroupId(groupId);
        txExceptionParams.setRegistrar(Short.valueOf((short)3));
        txExceptionParams.setTransactionState(Integer.valueOf(state));
        txExceptionParams.setUnitId(unitId);
        this.report(txExceptionParams);
    }

    private void report(TxExceptionParams exceptionParams) {
        TxMangerReporter.sendUntilNonManager(this.rpcClient, MessageCreator.writeTxException(exceptionParams), REPORT_ERROR_MESSAGE);
    }

    public static void sendUntilNonManager(RpcClient rpcClient, MessageDto messageDto, String whenNonManager) {
        while (true) {
            try {
                rpcClient.send(rpcClient.loadRemoteKey(), messageDto);
            }
            catch (RpcException e) {
                if (e.getCode() != 40010) continue;
                log.error(whenNonManager + ". non tx-manager is alive.");
            }
            break;
        }
    }

    public static MessageDto requestUntilNonManager(RpcClient rpcClient, MessageDto messageDto, String whenNonManager) throws RpcException {
        while (true) {
            try {
                return rpcClient.request(rpcClient.loadRemoteKey(), messageDto);
            }
            catch (RpcException e) {
                if (e.getCode() != 40010) continue;
                throw new RpcException(whenNonManager + ". non tx-manager is alive.");
            }
            break;
        }
    }
}

