/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.message.init;

import com.codingapi.txlcn.client.config.TxClientConfig;
import com.codingapi.txlcn.client.message.helper.MessageCreator;
import com.codingapi.txlcn.spi.message.ClientInitCallBack;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.params.InitClientParams;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TxClientClientInitCallBack
implements ClientInitCallBack {
    private static final Logger log = LoggerFactory.getLogger(TxClientClientInitCallBack.class);
    private final RpcClient rpcClient;
    private final TxClientConfig txClientConfig;
    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${server.port}")
    private Integer port;

    @Autowired
    public TxClientClientInitCallBack(RpcClient rpcClient, TxClientConfig txClientConfig) {
        this.rpcClient = rpcClient;
        this.txClientConfig = txClientConfig;
    }

    public void connected(String remoteKey) {
        String modId = this.appName + ":" + this.port;
        log.info("TC[{}] connect TM[{}] successfully!", (Object)modId, (Object)remoteKey);
        this.singleThreadExecutor.submit(() -> {
            try {
                log.info("Send init message to TM", (Object)remoteKey);
                MessageDto msg = this.rpcClient.request(remoteKey, MessageCreator.initClient(modId));
                if (msg.getData() != null) {
                    InitClientParams resParams = (InitClientParams)msg.loadBean(InitClientParams.class);
                    long dtxTime = resParams.getDtxTime();
                    this.txClientConfig.setDtxTime(dtxTime);
                    log.info("Determined dtx time {}ms.", (Object)dtxTime);
                }
            }
            catch (RpcException e) {
                log.error("Send init message error: {}", (Object)e.getMessage());
            }
        });
    }
}

