/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support;

import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.support.TXLCNTransactionSeparator;
import com.codingapi.txlcn.client.support.TXLCNTransactionState;
import com.codingapi.txlcn.commons.annotation.DTXPropagation;
import com.codingapi.txlcn.commons.exception.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizableTransactionSeparator
implements TXLCNTransactionSeparator {
    private static final Logger log = LoggerFactory.getLogger(CustomizableTransactionSeparator.class);

    @Override
    public TXLCNTransactionState loadTransactionState(TxTransactionInfo txTransactionInfo) throws TransactionException {
        if (DTXLocal.cur().isInUnit()) {
            log.info("Default by DTXLocal is not null! {}", (Object)DTXLocal.cur());
            return TXLCNTransactionState.DEFAULT;
        }
        if (txTransactionInfo.isTransactionStart()) {
            if (DTXPropagation.SUPPORTS.equals((Object)txTransactionInfo.getPropagation())) {
                return TXLCNTransactionState.NON;
            }
            return TXLCNTransactionState.STARTING;
        }
        return TXLCNTransactionState.RUNNING;
    }
}

