/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support;

import com.codingapi.txlcn.client.bean.DTXInfo;
import com.codingapi.txlcn.commons.util.Transactions;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.ConcurrentReferenceHashMap;

public class DTXInfoPool {
    private static final DTXInfoPool dtxInfoPool = new DTXInfoPool();
    private Map<String, DTXInfo> dtxInfoCache = new ConcurrentReferenceHashMap();

    private DTXInfoPool() {
    }

    private DTXInfo get0(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String signature = proceedingJoinPoint.getSignature().toString();
        String unitId = Transactions.unitId((String)signature);
        DTXInfo dtxInfo = this.dtxInfoCache.get(unitId);
        if (Objects.isNull(dtxInfo)) {
            MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
            Method method = methodSignature.getMethod();
            Class<?> targetClass = proceedingJoinPoint.getTarget().getClass();
            Method thisMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
            dtxInfo = new DTXInfo(thisMethod, proceedingJoinPoint.getArgs(), targetClass);
            this.dtxInfoCache.put(unitId, dtxInfo);
        }
        dtxInfo.reanalyseMethodArgs(proceedingJoinPoint.getArgs());
        return dtxInfo;
    }

    private DTXInfo get0(MethodInvocation methodInvocation) {
        String signature = methodInvocation.getMethod().toString();
        String unitId = Transactions.unitId((String)signature);
        DTXInfo dtxInfo = this.dtxInfoCache.get(unitId);
        if (Objects.isNull(dtxInfo)) {
            dtxInfo = new DTXInfo(methodInvocation.getMethod(), methodInvocation.getArguments(), methodInvocation.getThis().getClass());
            this.dtxInfoCache.put(unitId, dtxInfo);
        }
        dtxInfo.reanalyseMethodArgs(methodInvocation.getArguments());
        return dtxInfo;
    }

    private DTXInfo get0(Method method, Object[] args, Class<?> targetClass) {
        String signature = method.getName();
        String unitId = Transactions.unitId((String)signature);
        DTXInfo dtxInfo = this.dtxInfoCache.get(unitId);
        if (Objects.isNull(dtxInfo)) {
            dtxInfo = new DTXInfo(method, args, targetClass);
            this.dtxInfoCache.put(unitId, dtxInfo);
        }
        dtxInfo.reanalyseMethodArgs(args);
        return dtxInfo;
    }

    public static DTXInfo get(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return dtxInfoPool.get0(proceedingJoinPoint);
    }

    public static DTXInfo get(MethodInvocation methodInvocation) {
        return dtxInfoPool.get0(methodInvocation);
    }

    public static DTXInfo get(Method method, Object[] args, Class<?> targetClass) {
        return dtxInfoPool.get0(method, args, targetClass);
    }
}

