/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support;

import com.codingapi.txlcn.client.message.helper.RpcExecuteService;
import com.codingapi.txlcn.client.message.helper.TransactionCmd;
import com.codingapi.txlcn.client.support.cache.DTXGroupContext;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.commons.exception.TxClientException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.spi.message.params.NotifyUnitParams;
import java.io.Serializable;

public class DefaultNotifiedUnitService
implements RpcExecuteService {
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TxLogger txLogger;
    private final TransactionAttachmentCache transactionAttachmentCache;

    public DefaultNotifiedUnitService(TransactionCleanTemplate transactionCleanTemplate, TxLogger txLogger, TransactionAttachmentCache transactionAttachmentCache) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.txLogger = txLogger;
        this.transactionAttachmentCache = transactionAttachmentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxClientException {
        try {
            NotifyUnitParams notifyUnitParams = (NotifyUnitParams)transactionCmd.getMsg().loadBean(NotifyUnitParams.class);
            if (this.transactionAttachmentCache.hasContext(transactionCmd.getGroupId())) {
                DTXGroupContext groupContext = (DTXGroupContext)this.transactionAttachmentCache.context(transactionCmd.getGroupId());
                Object object = groupContext.getLock();
                synchronized (object) {
                    this.txLogger.trace(transactionCmd.getGroupId(), notifyUnitParams.getUnitId(), "transaction", "clean transaction cmd waiting for business code finish.");
                    groupContext.getLock().wait();
                }
            }
            this.transactionCleanTemplate.clean(notifyUnitParams.getGroupId(), notifyUnitParams.getUnitId(), notifyUnitParams.getUnitType(), notifyUnitParams.getState());
            return null;
        }
        catch (TransactionClearException | InterruptedException e) {
            throw new TxClientException(e);
        }
    }
}

