/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support;

import com.codingapi.txlcn.client.message.helper.RpcExecuteService;
import com.codingapi.txlcn.client.support.TXLCNTransactionControl;
import com.codingapi.txlcn.client.support.TXLCNTransactionSeparator;
import com.codingapi.txlcn.client.support.TXLCNTransactionState;
import com.codingapi.txlcn.client.support.TransactionCleanService;
import com.codingapi.txlcn.client.support.resouce.TransactionResourceExecutor;
import com.codingapi.txlcn.spi.message.LCNCmdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TXLCNTransactionBeanHelper {
    private static final Logger log = LoggerFactory.getLogger(TXLCNTransactionBeanHelper.class);
    private static final String CONTROL_BEAN_NAME_FORMAT = "control_%s_%s";
    private static final String RPC_BEAN_NAME_FORMAT = "rpc_%s_%s";
    private static final String TRANSACTION_BEAN_NAME_FORMAT = "transaction_%s";
    private static final String TRANSACTION_STATE_RESOLVER_BEAN_NAME_FORMAT = "transaction_state_resolver_%s";
    private static final String TRANSACTION_CLEAN_SERVICE_NAME_FORMAT = "%sTransactionCleanService";
    private final ApplicationContext spring;

    @Autowired
    public TXLCNTransactionBeanHelper(ApplicationContext spring) {
        this.spring = spring;
    }

    private String getControlBeanName(String transactionType, TXLCNTransactionState lcnTransactionState) {
        String name = String.format(CONTROL_BEAN_NAME_FORMAT, transactionType, lcnTransactionState.getCode());
        log.debug("getControlBeanName->{}", (Object)name);
        return name;
    }

    private String getRpcBeanName(String transactionType, LCNCmdType cmdType) {
        if (transactionType != null) {
            String name = String.format(RPC_BEAN_NAME_FORMAT, transactionType, cmdType.getCode());
            log.debug("getRpcBeanName->{}", (Object)name);
            return name;
        }
        String name = String.format(RPC_BEAN_NAME_FORMAT.replaceFirst("_%s", ""), cmdType.getCode());
        log.debug("getRpcBeanName->{}", (Object)name);
        return name;
    }

    public TransactionResourceExecutor loadTransactionResourceExecuter(String beanName) {
        String name = String.format(TRANSACTION_BEAN_NAME_FORMAT, beanName);
        log.debug("loadTransactionResourceExecutor name ->{}", (Object)name);
        return (TransactionResourceExecutor)this.spring.getBean(name, TransactionResourceExecutor.class);
    }

    private TXLCNTransactionControl loadLCNTransactionControl(String beanName) {
        return (TXLCNTransactionControl)this.spring.getBean(beanName, TXLCNTransactionControl.class);
    }

    public TXLCNTransactionControl loadLCNTransactionControl(String transactionType, TXLCNTransactionState lcnTransactionState) {
        return this.loadLCNTransactionControl(this.getControlBeanName(transactionType, lcnTransactionState));
    }

    public RpcExecuteService loadRpcExecuteService(String transactionType, LCNCmdType cmdType) {
        return this.loadRpcExecuteService(this.getRpcBeanName(transactionType, cmdType));
    }

    private RpcExecuteService loadRpcExecuteService(String beanName) {
        return (RpcExecuteService)this.spring.getBean(beanName, RpcExecuteService.class);
    }

    public TXLCNTransactionSeparator loadLCNTransactionStateResolver(String transactionType) {
        try {
            String name = String.format(TRANSACTION_STATE_RESOLVER_BEAN_NAME_FORMAT, transactionType);
            return (TXLCNTransactionSeparator)this.spring.getBean(name, TXLCNTransactionSeparator.class);
        }
        catch (Exception e) {
            return (TXLCNTransactionSeparator)this.spring.getBean(String.format(TRANSACTION_STATE_RESOLVER_BEAN_NAME_FORMAT, "default"), TXLCNTransactionSeparator.class);
        }
    }

    public TransactionCleanService loadTransactionCleanService(String transactionType) {
        return (TransactionCleanService)this.spring.getBean(String.format(TRANSACTION_CLEAN_SERVICE_NAME_FORMAT, transactionType), TransactionCleanService.class);
    }
}

