/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support;

import com.codingapi.txlcn.client.bean.TxTransactionInfo;
import com.codingapi.txlcn.client.support.TXLCNTransactionBeanHelper;
import com.codingapi.txlcn.client.support.TXLCNTransactionControl;
import com.codingapi.txlcn.client.support.TXLCNTransactionSeparator;
import com.codingapi.txlcn.client.support.TXLCNTransactionState;
import com.codingapi.txlcn.client.support.TransactionUnitTypeList;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.commons.exception.BeforeBusinessException;
import com.codingapi.txlcn.logger.TxLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TXLCNTransactionServiceExecutor {
    private static final Logger log = LoggerFactory.getLogger(TXLCNTransactionServiceExecutor.class);
    private final TransactionAttachmentCache transactionAttachmentCache;
    private final TxLogger txLogger;
    private final TXLCNTransactionBeanHelper txlcnTransactionBeanHelper;

    @Autowired
    public TXLCNTransactionServiceExecutor(TransactionAttachmentCache transactionAttachmentCache, TxLogger txLogger, TXLCNTransactionBeanHelper txlcnTransactionBeanHelper) {
        this.transactionAttachmentCache = transactionAttachmentCache;
        this.txLogger = txLogger;
        this.txlcnTransactionBeanHelper = txlcnTransactionBeanHelper;
    }

    public Object transactionRunning(TxTransactionInfo info) throws Throwable {
        String transactionType = info.getTransactionType();
        TXLCNTransactionSeparator lcnTransactionSeparator = this.txlcnTransactionBeanHelper.loadLCNTransactionStateResolver(transactionType);
        TXLCNTransactionState lcnTransactionState = lcnTransactionSeparator.loadTransactionState(info);
        if (lcnTransactionState.equals((Object)TXLCNTransactionState.NON)) {
            return info.getBusinessCallback().call();
        }
        TXLCNTransactionControl lcnTransactionControl = this.txlcnTransactionBeanHelper.loadLCNTransactionControl(transactionType, lcnTransactionState);
        this.transactionAttachmentCache.attach(info.getGroupId(), info.getUnitId(), new TransactionUnitTypeList().selfAdd(transactionType));
        try {
            this.txLogger.trace(info.getGroupId(), info.getUnitId(), "transaction", "pre service business code");
            lcnTransactionControl.preBusinessCode(info);
            this.txLogger.trace(info.getGroupId(), info.getUnitId(), "transaction", "do service business code");
            Object result = lcnTransactionControl.doBusinessCode(info);
            this.txLogger.trace(info.getGroupId(), info.getUnitId(), "transaction", "service business success");
            lcnTransactionControl.onBusinessCodeSuccess(info, result);
            Object object = result;
            return object;
        }
        catch (BeforeBusinessException e) {
            log.error("business", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.txLogger.trace(info.getGroupId(), info.getUnitId(), "transaction", "business code error");
            lcnTransactionControl.onBusinessCodeError(info, e);
            throw e;
        }
        finally {
            lcnTransactionControl.postBusinessCode(info);
        }
    }
}

