/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support.cache;

import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MapBasedTransactionAttachmentCache
implements TransactionAttachmentCache {
    private static final Logger log = LoggerFactory.getLogger(MapBasedTransactionAttachmentCache.class);
    private Map<String, GroupCache> transactionInfoMap = new ConcurrentHashMap<String, GroupCache>(64);
    private Map<String, Object> context = new ConcurrentHashMap<String, Object>(64);

    @Override
    public <T> void attach(String groupId, String unitId, T attachment) {
        if (Objects.isNull(groupId)) {
            log.warn("GroupId is null!");
            return;
        }
        if (this.transactionInfoMap.containsKey(groupId)) {
            GroupCache groupCache = this.transactionInfoMap.get(groupId);
            groupCache.getCache().put(attachment.getClass().getName(), attachment);
            groupCache.getUnits().add(unitId);
            return;
        }
        GroupCache groupCache = new GroupCache();
        groupCache.getUnits().add(unitId);
        groupCache.getCache().put(attachment.getClass().getName(), attachment);
        this.transactionInfoMap.put(groupId, groupCache);
    }

    @Override
    public void removeAttachments(String groupId, String unitId) {
        GroupCache groupCache = this.transactionInfoMap.get(groupId);
        if (Objects.isNull(groupCache)) {
            return;
        }
        groupCache.getUnits().remove(unitId);
        if (groupCache.getUnits().size() == 0) {
            this.transactionInfoMap.remove(groupId);
        }
    }

    @Override
    public <T> Optional<T> attachment(String groupId, Class<T> type) {
        if (Objects.isNull(groupId)) {
            log.warn("GroupId id null, so non attachment [{}]!", type);
            return Optional.empty();
        }
        GroupCache groupCache = this.transactionInfoMap.get(groupId);
        return Optional.ofNullable(Objects.isNull(groupCache) ? null : groupCache.getCache().get(type.getName()));
    }

    @Override
    public <T> T attachment(String groupId, String unitId, Class<T> type, Supplier<T> def) {
        Optional<T> optionalT = this.attachment(groupId, type);
        if (optionalT.isPresent()) {
            return optionalT.get();
        }
        this.attach(groupId, unitId, def.get());
        return this.attachment(groupId, unitId, type, def);
    }

    @Override
    public boolean hasGroup(String groupId) {
        if (Objects.isNull(groupId)) {
            log.warn("GroupId is null!");
            return false;
        }
        return this.transactionInfoMap.containsKey(groupId);
    }

    @Override
    public boolean hasAttachment(String groupId, Class<?> type) {
        return this.hasGroup(groupId) && this.transactionInfoMap.get(groupId).getCache().containsKey(type.getName());
    }

    @Override
    public <T> T context(String groupId) {
        return (T)this.context.get(groupId);
    }

    @Override
    public void setContext(String groupId, Object context) {
        this.context.put(groupId, context);
    }

    @Override
    public void destroyContext(String groupId) {
        this.context.remove(groupId);
    }

    @Override
    public boolean hasContext(String groupId) {
        return this.context.containsKey(groupId);
    }

    public class GroupCache {
        private Map<String, Object> cache = new HashMap<String, Object>();
        private Set<String> units = new HashSet<String>();

        public Map<String, Object> getCache() {
            return this.cache;
        }

        Set<String> getUnits() {
            return this.units;
        }

        public String toString() {
            return "GroupCache{cache=" + this.cache + ", units=" + this.units + '}';
        }
    }
}

