/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support.checking;

import com.codingapi.txlcn.client.message.helper.TxMangerReporter;
import com.codingapi.txlcn.client.support.checking.DTXExceptionHandler;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.commons.exception.BeforeBusinessException;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.commons.exception.TxClientException;
import com.codingapi.txlcn.commons.exception.UserRollbackException;
import com.codingapi.txlcn.spi.message.params.JoinGroupParams;
import com.codingapi.txlcn.spi.message.params.NotifyGroupParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultDTXExceptionHandler
implements DTXExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultDTXExceptionHandler.class);
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TxMangerReporter txMangerReporter;

    @Autowired
    public DefaultDTXExceptionHandler(TransactionCleanTemplate transactionCleanTemplate, TxMangerReporter txMangerReporter) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.txMangerReporter = txMangerReporter;
    }

    @Override
    public void handleCreateGroupBusinessException(Object params, Throwable ex) throws BeforeBusinessException {
        throw new BeforeBusinessException(ex);
    }

    @Override
    public void handleCreateGroupMessageException(Object params, Throwable ex) throws BeforeBusinessException {
        throw new BeforeBusinessException(ex);
    }

    @Override
    public void handleJoinGroupBusinessException(Object params, Throwable ex) throws TxClientException {
        JoinGroupParams joinGroupParams = (JoinGroupParams)params;
        try {
            this.transactionCleanTemplate.clean(joinGroupParams.getGroupId(), joinGroupParams.getUnitId(), joinGroupParams.getUnitType(), 0);
        }
        catch (TransactionClearException e) {
            log.error("{} > clean transaction error.", (Object)joinGroupParams.getUnitType());
        }
        throw new TxClientException(ex);
    }

    @Override
    public void handleJoinGroupMessageException(Object params, Throwable ex) throws TxClientException {
        throw new TxClientException(ex);
    }

    @Override
    public void handleNotifyGroupBusinessException(Object params, Throwable ex) {
        List paramList = (List)params;
        NotifyGroupParams notifyGroupParams = (NotifyGroupParams)paramList.get(0);
        String unitId = (String)paramList.get(1);
        String transactionType = (String)paramList.get(2);
        if (ex instanceof UserRollbackException) {
            notifyGroupParams.setState(0);
        }
        if (ex.getCause() != null && ex.getCause() instanceof UserRollbackException) {
            notifyGroupParams.setState(0);
        }
        try {
            this.transactionCleanTemplate.clean(notifyGroupParams.getGroupId(), unitId, transactionType, notifyGroupParams.getState());
        }
        catch (TransactionClearException e) {
            log.error("{} > clean transaction error.", (Object)transactionType);
        }
    }

    @Override
    public void handleNotifyGroupMessageException(Object params, Throwable ex) {
        List paramList = (List)params;
        NotifyGroupParams notifyGroupParams = (NotifyGroupParams)paramList.get(0);
        if (notifyGroupParams.getState() == 0) {
            this.handleNotifyGroupBusinessException(params, ex);
            return;
        }
        String unitId = (String)paramList.get(1);
        String transactionType = (String)paramList.get(2);
        try {
            this.transactionCleanTemplate.compensationClean(notifyGroupParams.getGroupId(), unitId, transactionType, notifyGroupParams.getState());
        }
        catch (TransactionClearException e) {
            log.error("{} > compensationClean transaction error.", (Object)transactionType);
        }
        this.txMangerReporter.reportTransactionState(notifyGroupParams.getGroupId(), null, (short)2, notifyGroupParams.getState());
    }
}

