/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support.checking;

import com.codingapi.txlcn.client.aspectlog.AspectLogger;
import com.codingapi.txlcn.client.config.TxClientConfig;
import com.codingapi.txlcn.client.message.helper.MessageCreator;
import com.codingapi.txlcn.client.message.helper.TxMangerReporter;
import com.codingapi.txlcn.client.support.cache.DTXGroupContext;
import com.codingapi.txlcn.client.support.cache.TransactionAttachmentCache;
import com.codingapi.txlcn.client.support.checking.DTXChecking;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleDTXChecking
implements DTXChecking {
    private static final Logger log = LoggerFactory.getLogger(SimpleDTXChecking.class);
    private static final Map<String, ScheduledFuture> delayTasks = new ConcurrentHashMap<String, ScheduledFuture>();
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private TransactionCleanTemplate transactionCleanTemplate;
    private final RpcClient rpcClient;
    private final TxClientConfig clientConfig;
    private final TxLogger txLogger;
    private final AspectLogger aspectLogger;
    private final TxMangerReporter txMangerReporter;
    private final TransactionAttachmentCache transactionAttachmentCache;

    @Autowired
    public SimpleDTXChecking(RpcClient rpcClient, TxClientConfig clientConfig, AspectLogger aspectLogger, TxLogger txLogger, TxMangerReporter txMangerReporter, TransactionAttachmentCache transactionAttachmentCache) {
        this.rpcClient = rpcClient;
        this.clientConfig = clientConfig;
        this.aspectLogger = aspectLogger;
        this.txLogger = txLogger;
        this.txMangerReporter = txMangerReporter;
        this.transactionAttachmentCache = transactionAttachmentCache;
    }

    public void setTransactionCleanTemplate(TransactionCleanTemplate transactionCleanTemplate) {
        this.transactionCleanTemplate = transactionCleanTemplate;
    }

    @Override
    public void startDelayCheckingAsync(String groupId, String unitId, String transactionType) {
        this.txLogger.trace(groupId, unitId, "task", "start delay checking task");
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(() -> {
            try {
                if (this.transactionAttachmentCache.hasContext(groupId)) {
                    DTXGroupContext context = (DTXGroupContext)this.transactionAttachmentCache.context(groupId);
                    Object object = context.getLock();
                    synchronized (object) {
                        this.txLogger.trace(groupId, unitId, "task", "checking waiting for business code finish.");
                        context.getLock().wait();
                    }
                }
                MessageDto messageDto = TxMangerReporter.requestUntilNonManager(this.rpcClient, MessageCreator.askTransactionState(groupId, unitId), "ask transaction state error.");
                short state = (Short)messageDto.loadBean(Short.class);
                log.debug("support > ask transaction transactionState:{}", (Object)state);
                this.txLogger.trace(groupId, unitId, "task", "ask transaction transactionState " + state);
                if (state == -1) {
                    log.error("delay clean transaction error.");
                    this.onAskTransactionStateException(groupId, unitId, transactionType);
                } else {
                    this.transactionCleanTemplate.clean(groupId, unitId, transactionType, state);
                    this.aspectLogger.clearLog(groupId, unitId);
                }
            }
            catch (RpcException e) {
                this.onAskTransactionStateException(groupId, unitId, transactionType);
            }
            catch (TransactionClearException | InterruptedException e) {
                log.error("{} > [transaction transactionState message] error or [clean transaction] error.", (Object)transactionType);
            }
        }, this.clientConfig.getDtxTime(), TimeUnit.MILLISECONDS);
        delayTasks.put(groupId + unitId, scheduledFuture);
    }

    @Override
    public void stopDelayChecking(String groupId, String unitId) {
        ScheduledFuture scheduledFuture = delayTasks.get(groupId + unitId);
        if (Objects.nonNull(scheduledFuture)) {
            this.txLogger.trace(groupId, unitId, "task", "stop delay checking task");
            log.debug("cancel {}:{} checking.", (Object)groupId, (Object)unitId);
            scheduledFuture.cancel(true);
        }
    }

    private void onAskTransactionStateException(String groupId, String unitId, String transactionType) {
        try {
            this.txMangerReporter.reportTransactionState(groupId, unitId, (short)1, 0);
            log.warn("{} > has compensation info!", (Object)transactionType);
            this.transactionCleanTemplate.compensationClean(groupId, unitId, transactionType, 0);
        }
        catch (TransactionClearException e) {
            log.error("{} > clean transaction error.", (Object)transactionType);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            scheduledExecutorService.shutdown();
            try {
                scheduledExecutorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
    }
}

