/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support.template;

import com.codingapi.txlcn.client.aspectlog.AspectLogger;
import com.codingapi.txlcn.client.support.TXLCNTransactionBeanHelper;
import com.codingapi.txlcn.client.support.checking.DTXChecking;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.logger.TxLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionCleanTemplate {
    private static final Logger log = LoggerFactory.getLogger(TransactionCleanTemplate.class);
    private final TXLCNTransactionBeanHelper transactionBeanHelper;
    private final DTXChecking dtxChecking;
    private final AspectLogger aspectLogger;
    private final TxLogger txLogger;

    @Autowired
    public TransactionCleanTemplate(TXLCNTransactionBeanHelper transactionBeanHelper, DTXChecking dtxChecking, AspectLogger aspectLogger, TxLogger txLogger) {
        this.transactionBeanHelper = transactionBeanHelper;
        this.dtxChecking = dtxChecking;
        this.aspectLogger = aspectLogger;
        this.txLogger = txLogger;
    }

    public void clean(String groupId, String unitId, String unitType, int state) throws TransactionClearException {
        this.txLogger.trace(groupId, unitId, "transaction", "clean transaction");
        this.transactionBeanHelper.loadTransactionCleanService(unitType).clear(groupId, state, unitId, unitType);
        this.dtxChecking.stopDelayChecking(groupId, unitId);
        this.aspectLogger.clearLog(groupId, unitId);
        this.txLogger.trace(groupId, unitId, "transaction", "clean transaction over");
        log.debug("clean transaction over");
    }

    public void compensationClean(String groupId, String unitId, String unitType, int state) throws TransactionClearException {
        this.txLogger.trace(groupId, unitId, "transaction", "clean compensation transaction");
        this.transactionBeanHelper.loadTransactionCleanService(unitType).clear(groupId, state, unitId, unitType);
        this.dtxChecking.stopDelayChecking(groupId, unitId);
    }
}

