/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.client.support.template;

import com.codingapi.txlcn.client.aspectlog.AspectLogger;
import com.codingapi.txlcn.client.bean.DTXLocal;
import com.codingapi.txlcn.client.message.helper.MessageCreator;
import com.codingapi.txlcn.client.support.checking.DTXChecking;
import com.codingapi.txlcn.client.support.checking.DTXExceptionHandler;
import com.codingapi.txlcn.client.support.template.TransactionCleanTemplate;
import com.codingapi.txlcn.commons.bean.TransactionInfo;
import com.codingapi.txlcn.commons.exception.BeforeBusinessException;
import com.codingapi.txlcn.commons.exception.TransactionClearException;
import com.codingapi.txlcn.commons.exception.TxClientException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.params.JoinGroupParams;
import com.codingapi.txlcn.spi.message.params.NotifyGroupParams;
import com.codingapi.txlcn.spi.message.util.MessageUtils;
import com.codingapi.txlcn.spi.sleuth.TracerHelper;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionControlTemplate {
    private static final Logger log = LoggerFactory.getLogger(TransactionControlTemplate.class);
    private final RpcClient rpcClient;
    private final TracerHelper tracerHelper;
    private final AspectLogger aspectLogger;
    private final DTXChecking dtxChecking;
    private final DTXExceptionHandler dtxExceptionHandler;
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TxLogger txLogger;

    @Autowired
    public TransactionControlTemplate(RpcClient rpcClient, TracerHelper tracerHelper, AspectLogger aspectLogger, DTXChecking dtxChecking, DTXExceptionHandler dtxExceptionHandler, TransactionCleanTemplate transactionCleanTemplate, TxLogger txLogger) {
        this.rpcClient = rpcClient;
        this.tracerHelper = tracerHelper;
        this.aspectLogger = aspectLogger;
        this.dtxChecking = dtxChecking;
        this.dtxExceptionHandler = dtxExceptionHandler;
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.txLogger = txLogger;
    }

    public void createGroup(String groupId, String unitId, TransactionInfo transactionInfo, String transactionType) throws BeforeBusinessException {
        this.txLogger.trace(groupId, unitId, "transaction", "create group");
        String remoteKey = null;
        try {
            remoteKey = this.rpcClient.loadRemoteKey();
            this.tracerHelper.createGroupId(groupId, remoteKey);
            log.debug("transaction type[{}] > create group > groupId: {}, unitId: {}, remoteKey: {}", new Object[]{transactionType, groupId, unitId, remoteKey});
            MessageDto messageDto = this.rpcClient.request(remoteKey, MessageCreator.createGroup(groupId));
            if (MessageUtils.statusOk((MessageDto)messageDto)) {
                log.debug("{} > create transaction group: {}, txManager: {}.", new Object[]{transactionType, groupId, remoteKey});
                this.aspectLogger.trace(groupId, unitId, transactionInfo);
                return;
            }
            this.dtxExceptionHandler.handleCreateGroupBusinessException(Arrays.asList(groupId, remoteKey), new Exception("TxManager\u4e1a\u52a1\u5f02\u5e38"));
        }
        catch (RpcException e) {
            this.dtxExceptionHandler.handleCreateGroupMessageException(Arrays.asList(groupId, remoteKey), e);
        }
        this.txLogger.trace(groupId, unitId, "transaction", "create group over");
    }

    public void joinGroup(String groupId, String unitId, String transactionType, TransactionInfo transactionInfo) throws TxClientException {
        this.txLogger.trace(groupId, unitId, "transaction", "join group");
        String managerKey = Optional.ofNullable(this.tracerHelper.getTxManagerKey()).orElseThrow(() -> new RuntimeException("sleuth pass error."));
        JoinGroupParams joinGroupParams = new JoinGroupParams();
        joinGroupParams.setGroupId(groupId);
        joinGroupParams.setUnitId(unitId);
        joinGroupParams.setUnitType(transactionType);
        joinGroupParams.setTransactionState(DTXLocal.transactionState());
        log.debug("transaction type[{}] > join group > groupId: {}, unitId: {}, remoteKeys: {}", new Object[]{transactionType, groupId, unitId, managerKey});
        try {
            MessageDto messageDto = this.rpcClient.request(managerKey, MessageCreator.joinGroup(joinGroupParams));
            if (MessageUtils.statusOk((MessageDto)messageDto)) {
                log.debug("{} > joined group.", (Object)transactionType);
                this.dtxChecking.startDelayCheckingAsync(groupId, unitId, transactionType);
                this.aspectLogger.trace(groupId, unitId, transactionInfo);
                return;
            }
            this.dtxExceptionHandler.handleJoinGroupBusinessException(joinGroupParams, new Exception("TxManager\u52a0\u5165\u4e8b\u52a1\u7ec4\u4e1a\u52a1\u5f02\u5e38"));
        }
        catch (RpcException e) {
            this.dtxExceptionHandler.handleJoinGroupMessageException(joinGroupParams, e);
        }
        this.txLogger.trace(groupId, unitId, "transaction", "join group over");
    }

    public void notifyGroup(String groupId, String unitId, String transactionType, int state) {
        this.txLogger.trace(groupId, unitId, "transaction", "notify group " + state);
        NotifyGroupParams notifyGroupParams = new NotifyGroupParams();
        notifyGroupParams.setGroupId(groupId);
        notifyGroupParams.setState(state);
        String managerKey = Optional.ofNullable(this.tracerHelper.getTxManagerKey()).orElseThrow(() -> new IllegalStateException("DTX Error(check TM cluster.) or Sleuth not configured."));
        log.debug("transaction type[{}] > close group > groupId: {}, unitId: {}, remoteKeys: {}", new Object[]{transactionType, groupId, unitId, managerKey});
        try {
            MessageDto messageDto = this.rpcClient.request(managerKey, MessageCreator.notifyGroup(notifyGroupParams));
            if (MessageUtils.statusOk((MessageDto)messageDto)) {
                log.debug("{} > close transaction group.", (Object)transactionType);
                this.transactionCleanTemplate.clean(groupId, unitId, transactionType, state);
                return;
            }
            this.dtxExceptionHandler.handleNotifyGroupBusinessException(Arrays.asList(notifyGroupParams, unitId, transactionType), (Throwable)messageDto.loadBean(Throwable.class));
        }
        catch (TransactionClearException e) {
            log.error("clear exception", (Throwable)e);
        }
        catch (RpcException e) {
            this.dtxExceptionHandler.handleNotifyGroupMessageException(Arrays.asList(notifyGroupParams, unitId, transactionType), e);
        }
        this.txLogger.trace(groupId, unitId, "transaction", "notify group exception " + state);
    }
}

