/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.context;

import com.codingapi.txlcn.commons.exception.JoinGroupException;
import com.codingapi.txlcn.commons.exception.TransactionException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.manager.core.context.DTXTransaction;
import com.codingapi.txlcn.manager.core.context.DTXTransactionContext;
import com.codingapi.txlcn.manager.core.context.TransactionManager;
import com.codingapi.txlcn.manager.core.group.GroupRelationship;
import com.codingapi.txlcn.manager.core.group.TransUnit;
import com.codingapi.txlcn.manager.core.group.TransactionUnit;
import com.codingapi.txlcn.manager.core.message.MessageCreator;
import com.codingapi.txlcn.manager.core.message.RpcExceptionHandler;
import com.codingapi.txlcn.manager.support.service.TxExceptionService;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.params.NotifyUnitParams;
import com.codingapi.txlcn.spi.message.util.MessageUtils;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleTransactionManager
implements TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleTransactionManager.class);
    private final GroupRelationship groupRelationship;
    private final RpcExceptionHandler rpcExceptionHandler;
    private final RpcClient rpcClient;
    private final TxLogger txLogger;
    private final TxExceptionService exceptionService;
    private final DTXTransactionContext transactionContext;

    @Autowired
    public SimpleTransactionManager(GroupRelationship groupRelationship, RpcExceptionHandler rpcExceptionHandler, RpcClient rpcClient, TxLogger txLogger, TxExceptionService exceptionService, DTXTransactionContext transactionContext) {
        this.rpcExceptionHandler = rpcExceptionHandler;
        this.groupRelationship = groupRelationship;
        this.exceptionService = exceptionService;
        this.rpcClient = rpcClient;
        this.txLogger = txLogger;
        this.transactionContext = transactionContext;
    }

    @Override
    public void begin(DTXTransaction dtxTransaction) {
        this.groupRelationship.createGroup(dtxTransaction.groupId());
    }

    @Override
    public void join(DTXTransaction dtxTransaction, TransactionUnit transactionUnit) throws TransactionException {
        TransUnit transUnit = new TransUnit();
        transUnit.setRemoteKey(transactionUnit.messageContextId());
        transUnit.setUnitType(transactionUnit.unitType());
        transUnit.setUnitId(transactionUnit.unitId());
        log.debug("unit:{} joined group:{}", (Object)transactionUnit.unitId(), (Object)dtxTransaction.groupId());
        try {
            if (transactionUnit.getTransactionState() == 0) {
                this.groupRelationship.setTransactionState(dtxTransaction.groupId(), 0);
            }
            this.groupRelationship.joinGroup(dtxTransaction.groupId(), transUnit);
        }
        catch (JoinGroupException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public void commit(DTXTransaction transaction) {
        this.notifyTransaction(transaction.groupId(), 1);
    }

    @Override
    public void rollback(DTXTransaction transaction) {
        this.notifyTransaction(transaction.groupId(), 0);
    }

    @Override
    public void close(DTXTransaction groupTransaction) {
        this.transactionContext.destroyTransaction(groupTransaction.groupId());
        this.groupRelationship.removeGroup(groupTransaction.groupId());
    }

    @Override
    public int transactionState(DTXTransaction groupTransaction) {
        int state = this.exceptionService.transactionState(groupTransaction.groupId());
        if (state != -1) {
            return state;
        }
        return this.groupRelationship.transactionState(groupTransaction.groupId()).shortValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransaction(String groupId, int transactionState) {
        this.groupRelationship.setTransactionState(groupId, transactionState);
        List<TransUnit> transUnits = this.groupRelationship.unitsOfGroup(groupId);
        for (TransUnit transUnit : transUnits) {
            List<Object> params;
            NotifyUnitParams notifyUnitParams = new NotifyUnitParams();
            notifyUnitParams.setGroupId(groupId);
            notifyUnitParams.setUnitId(transUnit.getUnitId());
            notifyUnitParams.setUnitType(transUnit.getUnitType());
            notifyUnitParams.setState(transactionState);
            this.txLogger.trace(groupId, notifyUnitParams.getUnitId(), "transaction", "notify unit");
            try {
                MessageDto respMsg = this.rpcClient.request(transUnit.getRemoteKey(), MessageCreator.notifyUnit(notifyUnitParams));
                log.debug("notify unit: {}", (Object)transUnit.getRemoteKey());
                if (MessageUtils.statusOk((MessageDto)respMsg)) continue;
                params = Arrays.asList(notifyUnitParams, transUnit.getRemoteKey());
                this.rpcExceptionHandler.handleNotifyUnitBusinessException(params, (Throwable)respMsg.loadBean(Throwable.class));
            }
            catch (RpcException e) {
                params = Arrays.asList(notifyUnitParams, transUnit.getRemoteKey());
                this.rpcExceptionHandler.handleNotifyUnitMessageException(params, e);
            }
            finally {
                this.txLogger.trace(groupId, notifyUnitParams.getUnitId(), "transaction", "notify unit over");
            }
        }
    }
}

