/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.message;

import com.codingapi.txlcn.manager.config.TxManagerConfig;
import com.codingapi.txlcn.manager.core.message.RpcCmdTask;
import com.codingapi.txlcn.manager.support.ManagerRpcBeanHelper;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HashGroupRpcCmdHandler {
    private static final Logger log = LoggerFactory.getLogger(HashGroupRpcCmdHandler.class);
    private final List<ExecutorService> executors;
    private final int concurrentLevel;
    private final ManagerRpcBeanHelper beanHelper;

    @Autowired
    public HashGroupRpcCmdHandler(ManagerRpcBeanHelper beanHelper, TxManagerConfig managerConfig) {
        this.concurrentLevel = Math.max((int)((double)Runtime.getRuntime().availableProcessors() / 0.19999999999999996), managerConfig.getConcurrentLevel());
        log.info("Transaction concurrent level is {}", (Object)this.concurrentLevel);
        this.beanHelper = beanHelper;
        this.executors = new ArrayList<ExecutorService>(this.concurrentLevel);
        for (int i = 0; i < this.concurrentLevel; ++i) {
            this.executors.add(Executors.newSingleThreadExecutor(r -> new Thread(r, "tx-cmd-executor")));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (ExecutorService executorService : this.executors) {
                executorService.shutdown();
            }
            for (ExecutorService executorService : this.executors) {
                try {
                    executorService.awaitTermination(10L, TimeUnit.MINUTES);
                }
                catch (InterruptedException interruptedException) {}
            }
        }));
    }

    public void handleMessage(RpcCmd rpcCmd) {
        String groupId = rpcCmd.getMsg().getGroupId();
        if (Objects.isNull(groupId)) {
            throw new IllegalStateException("bad request! message's groupId not nullable!");
        }
        int index = Math.abs(rpcCmd.getMsg().getGroupId().hashCode() % this.concurrentLevel);
        log.debug("group:{}'s message dispatched executor index: {}", (Object)rpcCmd.getMsg().getGroupId(), (Object)index);
        this.executors.get(index).submit(new RpcCmdTask(this.beanHelper, rpcCmd));
    }
}

