/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.message;

import com.codingapi.txlcn.manager.core.message.RpcExceptionHandler;
import com.codingapi.txlcn.manager.support.service.TxExceptionService;
import com.codingapi.txlcn.manager.support.service.WriteTxExceptionDTO;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.params.NotifyUnitParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManagerRpcExceptionHandler
implements RpcExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ManagerRpcExceptionHandler.class);
    private final TxExceptionService compensationService;
    private final RpcClient rpcClient;

    @Autowired
    public ManagerRpcExceptionHandler(TxExceptionService compensationService, RpcClient rpcClient) {
        this.compensationService = compensationService;
        this.rpcClient = rpcClient;
    }

    @Override
    public void handleNotifyUnitBusinessException(Object params, Throwable e) {
        this.handleNotifyUnitMessageException(params, e);
    }

    @Override
    public void handleNotifyUnitMessageException(Object params, Throwable e) {
        List paramList = (List)params;
        String modName = this.rpcClient.getAppName((String)paramList.get(1));
        NotifyUnitParams notifyUnitParams = (NotifyUnitParams)paramList.get(0);
        WriteTxExceptionDTO writeTxExceptionReq = new WriteTxExceptionDTO(notifyUnitParams.getGroupId(), notifyUnitParams.getUnitId(), modName, notifyUnitParams.getState());
        writeTxExceptionReq.setRegistrar((short)0);
        this.compensationService.writeTxException(writeTxExceptionReq);
    }
}

