/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.message;

import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.manager.core.message.MessageCreator;
import com.codingapi.txlcn.manager.core.message.RpcExecuteService;
import com.codingapi.txlcn.manager.core.message.TransactionCmd;
import com.codingapi.txlcn.manager.support.ManagerRpcBeanHelper;
import com.codingapi.txlcn.spi.message.LCNCmdType;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCmdTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RpcCmdTask.class);
    private final RpcCmd rpcCmd;
    private final ManagerRpcBeanHelper rpcBeanHelper;
    private final RpcClient rpcClient;
    private final TxLogger txLogger;

    public RpcCmdTask(ManagerRpcBeanHelper rpcBeanHelper, RpcCmd rpcCmd) {
        this.rpcBeanHelper = rpcBeanHelper;
        this.rpcCmd = rpcCmd;
        this.rpcClient = rpcBeanHelper.getByType(RpcClient.class);
        this.txLogger = rpcBeanHelper.getByType(TxLogger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TransactionCmd transactionCmd = this.parser(this.rpcCmd);
        String action = transactionCmd.getMsg().getAction();
        RpcExecuteService rpcExecuteService = this.rpcBeanHelper.loadManagerService(transactionCmd.getType());
        MessageDto messageDto = null;
        try {
            Serializable message = rpcExecuteService.execute(transactionCmd);
            messageDto = MessageCreator.notifyGroupOkResponse(message, action);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            messageDto = MessageCreator.notifyGroupFailResponse(e, action);
            this.txLogger.trace(transactionCmd.getGroupId(), "", "rpccmd", "error->" + messageDto.getAction());
        }
        finally {
            if (this.rpcCmd.getKey() != null) {
                assert (Objects.nonNull(messageDto));
                try {
                    messageDto.setGroupId(this.rpcCmd.getMsg().getGroupId());
                    this.rpcCmd.setMsg(messageDto);
                    this.rpcClient.send(this.rpcCmd);
                    this.txLogger.trace(transactionCmd.getGroupId(), "", "rpccmd", "success->" + messageDto.getAction());
                }
                catch (RpcException message) {}
            }
        }
    }

    private TransactionCmd parser(RpcCmd rpcCmd) {
        TransactionCmd cmd = new TransactionCmd();
        cmd.setRequestKey(rpcCmd.getKey());
        cmd.setRemoteKey(rpcCmd.getRemoteKey());
        cmd.setType(LCNCmdType.parserCmd((String)rpcCmd.getMsg().getAction()));
        cmd.setGroupId(rpcCmd.getMsg().getGroupId());
        cmd.setMsg(rpcCmd.getMsg());
        return cmd;
    }
}

