/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.message;

import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.manager.core.message.HashGroupRpcCmdHandler;
import com.codingapi.txlcn.manager.core.message.MessageCreator;
import com.codingapi.txlcn.spi.message.RpcAnswer;
import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerRpcAnswer
implements RpcAnswer {
    private static final Logger log = LoggerFactory.getLogger(ServerRpcAnswer.class);
    private final HashGroupRpcCmdHandler hashGroupRpcCmdHandler;
    private final RpcClient rpcClient;
    @Autowired
    private TxLogger txLogger;

    @Autowired
    public ServerRpcAnswer(HashGroupRpcCmdHandler hashGroupRpcCmdHandler, RpcClient rpcClient) {
        this.hashGroupRpcCmdHandler = hashGroupRpcCmdHandler;
        this.rpcClient = rpcClient;
    }

    public void callback(RpcCmd rpcCmd) {
        block4: {
            this.txLogger.trace(rpcCmd.getMsg().getGroupId(), "", "rpccmd", rpcCmd.getMsg().getAction());
            try {
                this.hashGroupRpcCmdHandler.handleMessage(rpcCmd);
            }
            catch (Throwable e) {
                if (rpcCmd.getKey() == null) break block4;
                log.info("send response.");
                String action = rpcCmd.getMsg().getAction();
                rpcCmd.setMsg(MessageCreator.serverException(action));
                try {
                    this.rpcClient.send(rpcCmd);
                    log.info("send response ok.");
                }
                catch (RpcException ignored) {
                    log.error("requester:{} dead.", (Object)rpcCmd.getRemoteKey());
                }
            }
        }
    }
}

