/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.manager.core.transaction;

import com.codingapi.txlcn.commons.exception.TransactionException;
import com.codingapi.txlcn.commons.exception.TxManagerException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.manager.core.context.DTXTransaction;
import com.codingapi.txlcn.manager.core.context.DTXTransactionContext;
import com.codingapi.txlcn.manager.core.context.TransactionManager;
import com.codingapi.txlcn.manager.core.message.RpcExecuteService;
import com.codingapi.txlcn.manager.core.message.TransactionCmd;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_create-group")
public class CreateGroupExecuteService
implements RpcExecuteService {
    private final TxLogger txLogger;
    private final TransactionManager transactionManager;
    private final DTXTransactionContext transactionContext;

    @Autowired
    public CreateGroupExecuteService(TxLogger txLogger, TransactionManager transactionManager, DTXTransactionContext transactionContext) {
        this.txLogger = txLogger;
        this.transactionManager = transactionManager;
        this.transactionContext = transactionContext;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        DTXTransaction dtxTransaction = this.transactionContext.newContext(transactionCmd.getGroupId());
        try {
            this.transactionManager.begin(dtxTransaction);
        }
        catch (TransactionException e) {
            throw new TxManagerException((Throwable)e);
        }
        this.txLogger.trace(transactionCmd.getGroupId(), "", "transaction", "create group");
        return null;
    }
}

